/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.mongodb.crypt.capi.Logger;
import com.mongodb.crypt.capi.Loggers;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptContextImpl;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

class MongoCryptImpl
implements MongoCrypt {
    private static final Logger LOGGER = Loggers.getLogger();
    private final CAPI.mongocrypt_t wrapped = CAPI.mongocrypt_new();
    private volatile boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MongoCryptImpl(MongoCryptOptions options) {
        if (this.wrapped == null) {
            throw new MongoCryptException("Unable to create new mongocrypt object");
        }
        boolean success = CAPI.mongocrypt_setopt_log_handler(this.wrapped, new LogCallback(), null);
        if (!success) {
            this.throwExceptionFromStatus();
        }
        if (options.getLocalKmsProviderOptions() != null) {
            CAPI.mongocrypt_binary_t localMasterKeyBinary = CAPIHelper.toBinary(options.getLocalKmsProviderOptions().getLocalMasterKey());
            try {
                success = CAPI.mongocrypt_setopt_kms_provider_local(this.wrapped, localMasterKeyBinary);
                if (!success) {
                    this.throwExceptionFromStatus();
                }
            }
            finally {
                CAPI.mongocrypt_binary_destroy(localMasterKeyBinary);
            }
        }
        if (options.getAwsKmsProviderOptions() != null && !(success = CAPI.mongocrypt_setopt_kms_provider_aws(this.wrapped, new CAPI.cstring(options.getAwsKmsProviderOptions().getAccessKeyId()), -1, new CAPI.cstring(options.getAwsKmsProviderOptions().getSecretAccessKey()), -1))) {
            this.throwExceptionFromStatus();
        }
        if (options.getLocalSchemaMap() != null) {
            BsonDocument localSchemaMapDocument = new BsonDocument();
            for (Map.Entry<String, BsonDocument> cur : options.getLocalSchemaMap().entrySet()) {
                localSchemaMapDocument.put(cur.getKey(), (BsonValue)cur.getValue());
            }
            CAPI.mongocrypt_binary_t localSchemaMapBinary = CAPIHelper.toBinary(localSchemaMapDocument);
            try {
                success = CAPI.mongocrypt_setopt_schema_map(this.wrapped, localSchemaMapBinary);
                if (!success) {
                    this.throwExceptionFromStatus();
                }
            }
            finally {
                CAPI.mongocrypt_binary_destroy(localSchemaMapBinary);
            }
        }
        if (!(success = CAPI.mongocrypt_init(this.wrapped))) {
            this.throwExceptionFromStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoCryptContext createEncryptionContext(String database, BsonDocument commandDocument) {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        Assertions.notNull((String)"database", (Object)database);
        Assertions.notNull((String)"commandDocument", (Object)commandDocument);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        CAPI.mongocrypt_binary_t commandDocumentBinary = CAPIHelper.toBinary(commandDocument);
        try {
            boolean success = CAPI.mongocrypt_ctx_encrypt_init(context, new CAPI.cstring(database), -1, commandDocumentBinary);
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
            MongoCryptContextImpl mongoCryptContextImpl = new MongoCryptContextImpl(context);
            return mongoCryptContextImpl;
        }
        finally {
            CAPI.mongocrypt_binary_destroy(commandDocumentBinary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MongoCryptContext createDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        CAPI.mongocrypt_binary_t documentBinary = CAPIHelper.toBinary(document);
        try {
            boolean success = CAPI.mongocrypt_ctx_decrypt_init(context, documentBinary);
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
        }
        finally {
            CAPI.mongocrypt_binary_destroy(documentBinary);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createDataKeyContext(String kmsProvider, MongoDataKeyOptions options) {
        boolean success;
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (kmsProvider.equals("aws")) {
            success = CAPI.mongocrypt_ctx_setopt_masterkey_aws(context, new CAPI.cstring(options.getMasterKey().getString((Object)"region").getValue()), -1, new CAPI.cstring(options.getMasterKey().getString((Object)"key").getValue()), -1);
        } else if (kmsProvider.equals("local")) {
            success = CAPI.mongocrypt_ctx_setopt_masterkey_local(context);
        } else {
            throw new IllegalArgumentException("Unsupported KMS provider " + kmsProvider);
        }
        if (!success) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        if (!(success = CAPI.mongocrypt_ctx_datakey_init(context))) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        return new MongoCryptContextImpl(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public MongoCryptContext createExplicitEncryptionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Assertions.isTrue((String)"open", (boolean)(this.closed == false));
        context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (options.getKeyId() != null) {
            keyIdBinary = CAPIHelper.toBinary(ByteBuffer.wrap(options.getKeyId().getData()));
            try {
                success = CAPI.mongocrypt_ctx_setopt_key_id(context, keyIdBinary);
                if (success) ** GOTO lbl25
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
            finally {
                CAPI.mongocrypt_binary_destroy(keyIdBinary);
            }
        } else if (options.getKeyAltName() != null) {
            keyAltNameBinary = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(options.getKeyAltName())));
            try {
                success = CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinary);
                if (!success) {
                    MongoCryptContextImpl.throwExceptionFromStatus(context);
                }
            }
            finally {
                CAPI.mongocrypt_binary_destroy(keyAltNameBinary);
            }
        }
        if (!(success = CAPI.mongocrypt_ctx_setopt_algorithm(context, new CAPI.cstring(options.getAlgorithm()), -1))) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        documentBinary = CAPIHelper.toBinary(document);
        try {
            success = CAPI.mongocrypt_ctx_explicit_encrypt_init(context, documentBinary);
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
        }
        finally {
            CAPI.mongocrypt_binary_destroy(documentBinary);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitDecryptionContext(BsonDocument document) {
        boolean success;
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (!(success = CAPI.mongocrypt_ctx_explicit_decrypt_init(context, CAPIHelper.toBinary(document)))) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public void close() {
        CAPI.mongocrypt_destroy(this.wrapped);
        this.closed = true;
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(status);
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }

    static class LogCallback
    implements CAPI.mongocrypt_log_fn_t {
        LogCallback() {
        }

        @Override
        public void log(int level, CAPI.cstring message, int messageLength, Pointer ctx) {
            if (level == 0) {
                LOGGER.error(message.toString());
            }
            if (level == 1) {
                LOGGER.error(message.toString());
            }
            if (level == 2) {
                LOGGER.warn(message.toString());
            }
            if (level == 3) {
                LOGGER.info(message.toString());
            }
            if (level == 4) {
                LOGGER.trace(message.toString());
            }
        }
    }
}

