/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import org.bson.assertions.Assertions;

class MongoKeyDecryptorImpl
implements MongoKeyDecryptor {
    private final CAPI.mongocrypt_kms_ctx_t wrapped;

    MongoKeyDecryptorImpl(CAPI.mongocrypt_kms_ctx_t wrapped) {
        Assertions.notNull((String)"wrapped", (Object)((Object)wrapped));
        this.wrapped = wrapped;
    }

    @Override
    public String getHostName() {
        PointerByReference hostNamePointerByReference = new PointerByReference();
        boolean success = CAPI.mongocrypt_kms_ctx_endpoint(this.wrapped, hostNamePointerByReference);
        if (!success) {
            this.throwExceptionFromStatus();
        }
        Pointer hostNamePointer = hostNamePointerByReference.getValue();
        return hostNamePointer.getString(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer getMessage() {
        CAPI.mongocrypt_binary_t binary = CAPI.mongocrypt_binary_new();
        try {
            boolean success = CAPI.mongocrypt_kms_ctx_message(this.wrapped, binary);
            if (!success) {
                this.throwExceptionFromStatus();
            }
            ByteBuffer byteBuffer = CAPIHelper.toByteBuffer(binary);
            return byteBuffer;
        }
        finally {
            CAPI.mongocrypt_binary_destroy(binary);
        }
    }

    @Override
    public int bytesNeeded() {
        return CAPI.mongocrypt_kms_ctx_bytes_needed(this.wrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void feed(ByteBuffer bytes) {
        CAPI.mongocrypt_binary_t binary = CAPIHelper.toBinary(bytes);
        try {
            boolean success = CAPI.mongocrypt_kms_ctx_feed(this.wrapped, binary);
            if (!success) {
                this.throwExceptionFromStatus();
            }
        }
        finally {
            CAPI.mongocrypt_binary_destroy(binary);
        }
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_kms_ctx_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(status);
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }
}

