/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoKeyDecryptor;
import com.mongodb.crypt.capi.MongoKeyDecryptorImpl;
import org.bson.BsonDocument;
import org.bson.RawBsonDocument;
import org.bson.assertions.Assertions;

class MongoCryptContextImpl
implements MongoCryptContext {
    private final CAPI.mongocrypt_ctx_t wrapped;
    private volatile boolean closed;

    MongoCryptContextImpl(CAPI.mongocrypt_ctx_t wrapped) {
        Assertions.notNull((String)"wrapped", (Object)((Object)wrapped));
        this.wrapped = wrapped;
    }

    @Override
    public MongoCryptContext.State getState() {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        return MongoCryptContext.State.fromIndex(CAPI.mongocrypt_ctx_state(this.wrapped));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawBsonDocument getMongoOperation() {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_binary_t binary = CAPI.mongocrypt_binary_new();
        try {
            boolean success = CAPI.mongocrypt_ctx_mongo_op(this.wrapped, binary);
            if (!success) {
                this.throwExceptionFromStatus();
            }
            RawBsonDocument rawBsonDocument = CAPIHelper.toDocument(binary);
            return rawBsonDocument;
        }
        finally {
            CAPI.mongocrypt_binary_destroy(binary);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMongoOperationResult(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_binary_t binary = CAPIHelper.toBinary(document);
        try {
            boolean success = CAPI.mongocrypt_ctx_mongo_feed(this.wrapped, binary);
            if (!success) {
                this.throwExceptionFromStatus();
            }
        }
        finally {
            CAPI.mongocrypt_binary_destroy(binary);
        }
    }

    @Override
    public void completeMongoOperation() {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        boolean success = CAPI.mongocrypt_ctx_mongo_done(this.wrapped);
        if (!success) {
            this.throwExceptionFromStatus();
        }
    }

    @Override
    public MongoKeyDecryptor nextKeyDecryptor() {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_kms_ctx_t kmsContext = CAPI.mongocrypt_ctx_next_kms_ctx(this.wrapped);
        if (kmsContext == null) {
            return null;
        }
        return new MongoKeyDecryptorImpl(kmsContext);
    }

    @Override
    public void completeKeyDecryptors() {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        boolean success = CAPI.mongocrypt_ctx_kms_done(this.wrapped);
        if (!success) {
            this.throwExceptionFromStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BsonDocument finish() {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_binary_t binary = CAPI.mongocrypt_binary_new();
        try {
            boolean success = CAPI.mongocrypt_ctx_finalize(this.wrapped, binary);
            if (!success) {
                this.throwExceptionFromStatus();
            }
            RawBsonDocument rawBsonDocument = CAPIHelper.toDocument(binary);
            return rawBsonDocument;
        }
        finally {
            CAPI.mongocrypt_binary_destroy(binary);
        }
    }

    @Override
    public void close() {
        CAPI.mongocrypt_ctx_destroy(this.wrapped);
        this.closed = true;
    }

    static void throwExceptionFromStatus(CAPI.mongocrypt_ctx_t wrapped) {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_ctx_status(wrapped, status);
        MongoCryptException e = new MongoCryptException(status);
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }

    private void throwExceptionFromStatus() {
        MongoCryptContextImpl.throwExceptionFromStatus(this.wrapped);
    }
}

