/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.CAPI;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;

final class CAPIHelper {
    private static final CodecRegistry CODEC_REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});

    static CAPI.mongocrypt_binary_t toBinary(BsonDocument document) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        BsonBinaryWriter writer = new BsonBinaryWriter((BsonOutput)buffer);
        CODEC_REGISTRY.get(document.getClass()).encode((BsonWriter)writer, (Object)document, EncoderContext.builder().build());
        Memory pointer = new Memory((long)buffer.size());
        pointer.write(0L, buffer.getInternalBuffer(), 0, buffer.size());
        return CAPI.mongocrypt_binary_new_from_data((Pointer)pointer, buffer.getSize());
    }

    static RawBsonDocument toDocument(CAPI.mongocrypt_binary_t binary) {
        ByteBuffer byteBuffer = CAPIHelper.toByteBuffer(binary);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return new RawBsonDocument(bytes);
    }

    static CAPI.mongocrypt_binary_t toBinary(ByteBuffer buffer) {
        byte[] message = new byte[buffer.remaining()];
        buffer.get(message, 0, buffer.remaining());
        Memory pointer = new Memory((long)message.length);
        pointer.write(0L, message, 0, message.length);
        return CAPI.mongocrypt_binary_new_from_data((Pointer)pointer, message.length);
    }

    static ByteBuffer toByteBuffer(CAPI.mongocrypt_binary_t binary) {
        Pointer pointer = CAPI.mongocrypt_binary_data(binary);
        int length = CAPI.mongocrypt_binary_len(binary);
        return pointer.getByteBuffer(0L, (long)length);
    }

    private CAPIHelper() {
    }
}

