/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ReadConcern;
import com.mongodb.connection.ClusterClock;
import com.mongodb.session.SessionContext;
import org.bson.BsonDocument;
import org.bson.BsonTimestamp;

final class ClusterClockAdvancingSessionContext
implements SessionContext {
    private final SessionContext wrapped;
    private final ClusterClock clusterClock;

    ClusterClockAdvancingSessionContext(SessionContext wrapped, ClusterClock clusterClock) {
        this.wrapped = wrapped;
        this.clusterClock = clusterClock;
    }

    @Override
    public boolean hasSession() {
        return this.wrapped.hasSession();
    }

    @Override
    public boolean isImplicitSession() {
        return this.wrapped.isImplicitSession();
    }

    @Override
    public BsonDocument getSessionId() {
        return this.wrapped.getSessionId();
    }

    @Override
    public boolean isCausallyConsistent() {
        return this.wrapped.isCausallyConsistent();
    }

    @Override
    public long getTransactionNumber() {
        return this.wrapped.getTransactionNumber();
    }

    @Override
    public long advanceTransactionNumber() {
        return this.wrapped.advanceTransactionNumber();
    }

    @Override
    public boolean notifyMessageSent() {
        return this.wrapped.notifyMessageSent();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.wrapped.getOperationTime();
    }

    @Override
    public void advanceOperationTime(BsonTimestamp operationTime) {
        this.wrapped.advanceOperationTime(operationTime);
    }

    @Override
    public BsonDocument getClusterTime() {
        return this.clusterClock.greaterOf(this.wrapped.getClusterTime());
    }

    @Override
    public void advanceClusterTime(BsonDocument clusterTime) {
        this.wrapped.advanceClusterTime(clusterTime);
        this.clusterClock.advance(clusterTime);
    }

    @Override
    public boolean hasActiveTransaction() {
        return this.wrapped.hasActiveTransaction();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }
}

