/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.lang.Nullable;
import org.bson.conversions.Bson;

public class AggregateOutStageOptions {
    private Mode mode = Mode.REPLACE_COLLECTION;
    private String databaseName;
    private Bson uniqueKey;

    public Mode getMode() {
        return this.mode;
    }

    public AggregateOutStageOptions mode(Mode mode) {
        Assertions.notNull("mode", mode);
        this.mode = mode;
        return this;
    }

    @Nullable
    public String getDatabaseName() {
        return this.databaseName;
    }

    public AggregateOutStageOptions databaseName(@Nullable String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Nullable
    public Bson getUniqueKey() {
        return this.uniqueKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateOutStageOptions that = (AggregateOutStageOptions)o;
        if (this.mode != that.mode) {
            return false;
        }
        if (this.databaseName != null ? !this.databaseName.equals(that.databaseName) : that.databaseName != null) {
            return false;
        }
        return this.uniqueKey != null ? this.uniqueKey.equals(that.uniqueKey) : that.uniqueKey == null;
    }

    public int hashCode() {
        int result = this.mode != null ? this.mode.hashCode() : 0;
        result = 31 * result + (this.databaseName != null ? this.databaseName.hashCode() : 0);
        result = 31 * result + (this.uniqueKey != null ? this.uniqueKey.hashCode() : 0);
        return result;
    }

    public AggregateOutStageOptions uniqueKey(@Nullable Bson uniqueKey) {
        this.uniqueKey = uniqueKey;
        return this;
    }

    public static enum Mode {
        REPLACE_COLLECTION,
        REPLACE_DOCUMENTS,
        INSERT_DOCUMENTS;

    }
}

