/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ConnectionString;
import com.mongodb.annotations.Immutable;

@Immutable
public class SSLSettings {
    private final boolean enabled;

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    SSLSettings(Builder builder) {
        this.enabled = builder.enabled;
    }

    public String toString() {
        return "SSLSettings{enabled=" + this.enabled + '}';
    }

    public static class Builder {
        private boolean enabled;

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder applyConnectionString(ConnectionString connectionString) {
            if (connectionString.getSslEnabled() != null) {
                this.enabled = connectionString.getSslEnabled();
            }
            return this;
        }

        public SSLSettings build() {
            return new SSLSettings(this);
        }
    }
}

