/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.FindFluentImpl;
import com.mongodb.ListIndexesFluentImpl;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.OperationIterable;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.FindFluent;
import com.mongodb.client.ListIndexesFluent;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.AggregateOptions;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOneModel;
import com.mongodb.client.model.DistinctOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.FindOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.MapReduceOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.operation.AggregateOperation;
import com.mongodb.operation.AggregateToCollectionOperation;
import com.mongodb.operation.CountOperation;
import com.mongodb.operation.CreateIndexOperation;
import com.mongodb.operation.DistinctOperation;
import com.mongodb.operation.DropCollectionOperation;
import com.mongodb.operation.DropIndexOperation;
import com.mongodb.operation.FindAndDeleteOperation;
import com.mongodb.operation.FindAndReplaceOperation;
import com.mongodb.operation.FindAndUpdateOperation;
import com.mongodb.operation.MapReduceToCollectionOperation;
import com.mongodb.operation.MapReduceWithInlineResultsOperation;
import com.mongodb.operation.MixedBulkWriteOperation;
import com.mongodb.operation.OperationExecutor;
import com.mongodb.operation.RenameCollectionOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDocumentWrapper;
import org.bson.BsonJavaScript;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecRegistry;

class MongoCollectionImpl<T>
implements MongoCollection<T> {
    private final MongoNamespace namespace;
    private final Class<T> clazz;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final OperationExecutor executor;

    MongoCollectionImpl(MongoNamespace namespace, Class<T> clazz, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, OperationExecutor executor) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.clazz = Assertions.notNull("clazz", clazz);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.executor = Assertions.notNull("executor", executor);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<T> getDefaultClass() {
        return this.clazz;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public <C> MongoCollection<C> withDefaultClass(Class<C> clazz) {
        return new MongoCollectionImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, codecRegistry, this.readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, readPreference, this.writeConcern, this.executor);
    }

    @Override
    public MongoCollection<T> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<T>(this.namespace, this.clazz, this.codecRegistry, this.readPreference, writeConcern, this.executor);
    }

    @Override
    public long count() {
        return this.count(new Document(), new CountOptions());
    }

    @Override
    public long count(Object filter) {
        return this.count(filter, new CountOptions());
    }

    @Override
    public long count(Object filter, CountOptions options) {
        CountOperation operation = new CountOperation(this.namespace).filter(this.asBson(filter)).skip(options.getSkip()).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        if (options.getHint() != null) {
            operation.hint(this.asBson(options.getHint()));
        } else if (options.getHintString() != null) {
            operation.hint(new BsonString(options.getHintString()));
        }
        return this.executor.execute(operation, this.readPreference);
    }

    @Override
    public List<Object> distinct(String fieldName, Object filter) {
        return this.distinct(fieldName, filter, new DistinctOptions());
    }

    @Override
    public List<Object> distinct(String fieldName, Object filter, DistinctOptions distinctOptions) {
        DistinctOperation operation = new DistinctOperation(this.namespace, fieldName).filter(this.asBson(filter)).maxTime(distinctOptions.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS);
        BsonArray distinctArray = this.executor.execute(operation, this.readPreference);
        ArrayList<Object> distinctList = new ArrayList<Object>();
        for (BsonValue value : distinctArray) {
            BsonDocument bsonDocument = new BsonDocument("value", value);
            Document document = (Document)this.getCodec(Document.class).decode(new BsonDocumentReader(bsonDocument), DecoderContext.builder().build());
            distinctList.add(document.get("value"));
        }
        return distinctList;
    }

    @Override
    public FindFluent<T> find() {
        return this.find(new BsonDocument(), this.clazz);
    }

    @Override
    public <C> FindFluent<C> find(Class<C> clazz) {
        return this.find(new BsonDocument(), clazz);
    }

    @Override
    public FindFluent<T> find(Object filter) {
        return this.find(filter, this.clazz);
    }

    @Override
    public <C> FindFluent<C> find(Object filter, Class<C> clazz) {
        return new FindFluentImpl<C>(this.namespace, clazz, this.codecRegistry, this.readPreference, this.executor, filter, new FindOptions());
    }

    @Override
    public MongoIterable<Document> aggregate(List<?> pipeline) {
        return this.aggregate(pipeline, Document.class);
    }

    @Override
    public <C> MongoIterable<C> aggregate(List<?> pipeline, Class<C> clazz) {
        return this.aggregate(pipeline, new AggregateOptions(), clazz);
    }

    @Override
    public MongoIterable<Document> aggregate(List<?> pipeline, AggregateOptions options) {
        return this.aggregate(pipeline, options, Document.class);
    }

    @Override
    public <C> MongoIterable<C> aggregate(List<?> pipeline, AggregateOptions options, Class<C> clazz) {
        BsonValue outCollection;
        List<BsonDocument> aggregateList = this.createBsonDocumentList(pipeline);
        BsonValue bsonValue = outCollection = aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get("$out");
        if (outCollection != null) {
            AggregateToCollectionOperation operation = new AggregateToCollectionOperation(this.namespace, aggregateList).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse());
            this.executor.execute(operation);
            return new FindFluentImpl<C>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), clazz, this.codecRegistry, this.readPreference, this.executor, new BsonDocument(), new FindOptions());
        }
        return new OperationIterable(new AggregateOperation<C>(this.namespace, aggregateList, this.getCodec(clazz)).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).allowDiskUse(options.getAllowDiskUse()).batchSize(options.getBatchSize()).useCursor(options.getUseCursor()), this.readPreference, this.executor);
    }

    @Override
    public MongoIterable<Document> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, new MapReduceOptions());
    }

    @Override
    public MongoIterable<Document> mapReduce(String mapFunction, String reduceFunction, MapReduceOptions options) {
        return this.mapReduce(mapFunction, reduceFunction, options, Document.class);
    }

    @Override
    public <C> MongoIterable<C> mapReduce(String mapFunction, String reduceFunction, Class<C> clazz) {
        return this.mapReduce(mapFunction, reduceFunction, new MapReduceOptions(), clazz);
    }

    @Override
    public <C> MongoIterable<C> mapReduce(String mapFunction, String reduceFunction, MapReduceOptions options, Class<C> clazz) {
        if (options.isInline()) {
            MapReduceWithInlineResultsOperation<C> operation = new MapReduceWithInlineResultsOperation<C>(this.getNamespace(), new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), this.getCodec(clazz)).filter(this.asBson(options.getFilter())).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(options.isJsMode()).scope(this.asBson(options.getScope())).sort(this.asBson(options.getSort())).verbose(options.isVerbose());
            if (options.getFinalizeFunction() != null) {
                operation.finalizeFunction(new BsonJavaScript(options.getFinalizeFunction()));
            }
            return new OperationIterable(operation, this.readPreference, this.executor);
        }
        MapReduceToCollectionOperation operation = new MapReduceToCollectionOperation(this.getNamespace(), new BsonJavaScript(mapFunction), new BsonJavaScript(reduceFunction), options.getCollectionName()).filter(this.asBson(options.getFilter())).limit(options.getLimit()).maxTime(options.getMaxTime(TimeUnit.MILLISECONDS), TimeUnit.MILLISECONDS).jsMode(options.isJsMode()).scope(this.asBson(options.getScope())).sort(this.asBson(options.getSort())).verbose(options.isVerbose()).action(options.getAction().getValue()).nonAtomic(options.isNonAtomic()).sharded(options.isSharded()).databaseName(options.getDatabaseName());
        if (options.getFinalizeFunction() != null) {
            operation.finalizeFunction(new BsonJavaScript(options.getFinalizeFunction()));
        }
        this.executor.execute(operation);
        String databaseName = options.getDatabaseName() != null ? options.getDatabaseName() : this.namespace.getDatabaseName();
        return new FindFluentImpl<C>(new MongoNamespace(databaseName, options.getCollectionName()), clazz, this.codecRegistry, ReadPreference.primary(), this.executor, new BsonDocument(), new FindOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> requests) {
        return this.bulkWrite(requests, new BulkWriteOptions());
    }

    @Override
    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> requests, BulkWriteOptions options) {
        ArrayList<InsertRequest> writeRequests = new ArrayList<InsertRequest>(requests.size());
        for (WriteModel<T> writeModel : requests) {
            WriteRequest writeRequest;
            if (writeModel instanceof InsertOneModel) {
                InsertOneModel insertOneModel = (InsertOneModel)writeModel;
                if (this.getCodec() instanceof CollectibleCodec) {
                    ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(insertOneModel.getDocument());
                }
                writeRequest = new InsertRequest(this.asBson(insertOneModel.getDocument()));
            } else if (writeModel instanceof ReplaceOneModel) {
                ReplaceOneModel replaceOneModel = (ReplaceOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(replaceOneModel.getFilter()), this.asBson(replaceOneModel.getReplacement()), WriteRequest.Type.REPLACE).upsert(replaceOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateOneModel) {
                UpdateOneModel updateOneModel = (UpdateOneModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateOneModel.getFilter()), this.asBson(updateOneModel.getUpdate()), WriteRequest.Type.UPDATE).multi(false).upsert(updateOneModel.getOptions().isUpsert());
            } else if (writeModel instanceof UpdateManyModel) {
                UpdateManyModel updateManyModel = (UpdateManyModel)writeModel;
                writeRequest = new UpdateRequest(this.asBson(updateManyModel.getFilter()), this.asBson(updateManyModel.getUpdate()), WriteRequest.Type.UPDATE).multi(true).upsert(updateManyModel.getOptions().isUpsert());
            } else if (writeModel instanceof DeleteOneModel) {
                DeleteOneModel deleteOneModel = (DeleteOneModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteOneModel.getFilter())).multi(false);
            } else if (writeModel instanceof DeleteManyModel) {
                DeleteManyModel deleteManyModel = (DeleteManyModel)writeModel;
                writeRequest = new DeleteRequest(this.asBson(deleteManyModel.getFilter())).multi(true);
            } else {
                throw new UnsupportedOperationException(String.format("WriteModel of type %s is not supported", writeModel.getClass()));
            }
            writeRequests.add((InsertRequest)writeRequest);
        }
        return this.executor.execute(new MixedBulkWriteOperation(this.namespace, writeRequests, options.isOrdered(), this.writeConcern));
    }

    @Override
    public void insertOne(T document) {
        if (this.getCodec() instanceof CollectibleCodec) {
            ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
        }
        this.executeSingleWriteRequest(new InsertRequest(this.asBson(document)));
    }

    @Override
    public void insertMany(List<? extends T> documents) {
        this.insertMany(documents, new InsertManyOptions());
    }

    @Override
    public void insertMany(List<? extends T> documents, InsertManyOptions options) {
        ArrayList<InsertRequest> requests = new ArrayList<InsertRequest>(documents.size());
        for (T document : documents) {
            if (this.getCodec() instanceof CollectibleCodec) {
                ((CollectibleCodec)this.getCodec()).generateIdIfAbsentFromDocument(document);
            }
            requests.add(new InsertRequest(this.asBson(document)));
        }
        this.executor.execute(new MixedBulkWriteOperation(this.namespace, requests, options.isOrdered(), this.writeConcern));
    }

    @Override
    public DeleteResult deleteOne(Object filter) {
        return this.delete(filter, false);
    }

    @Override
    public DeleteResult deleteMany(Object filter) {
        return this.delete(filter, true);
    }

    @Override
    public UpdateResult replaceOne(Object filter, T replacement) {
        return this.replaceOne(filter, replacement, new UpdateOptions());
    }

    @Override
    public UpdateResult replaceOne(Object filter, T replacement, UpdateOptions updateOptions) {
        return this.toUpdateResult(this.executeSingleWriteRequest(new UpdateRequest(this.asBson(filter), this.asBson(replacement), WriteRequest.Type.REPLACE).upsert(updateOptions.isUpsert())));
    }

    @Override
    public UpdateResult updateOne(Object filter, Object update) {
        return this.updateOne(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateOne(Object filter, Object update, UpdateOptions updateOptions) {
        return this.update(filter, update, updateOptions, false);
    }

    @Override
    public UpdateResult updateMany(Object filter, Object update) {
        return this.updateMany(filter, update, new UpdateOptions());
    }

    @Override
    public UpdateResult updateMany(Object filter, Object update, UpdateOptions updateOptions) {
        return this.update(filter, update, updateOptions, true);
    }

    @Override
    public T findOneAndDelete(Object filter) {
        return this.findOneAndDelete(filter, new FindOneAndDeleteOptions());
    }

    @Override
    public T findOneAndDelete(Object filter, FindOneAndDeleteOptions options) {
        return this.executor.execute(new FindAndDeleteOperation<T>(this.namespace, this.getCodec()).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())));
    }

    @Override
    public T findOneAndReplace(Object filter, T replacement) {
        return this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions());
    }

    @Override
    public T findOneAndReplace(Object filter, T replacement, FindOneAndReplaceOptions options) {
        return this.executor.execute(new FindAndReplaceOperation<T>(this.namespace, this.getCodec(), this.asBson(replacement)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()));
    }

    @Override
    public T findOneAndUpdate(Object filter, Object update) {
        return this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions());
    }

    @Override
    public T findOneAndUpdate(Object filter, Object update, FindOneAndUpdateOptions options) {
        return this.executor.execute(new FindAndUpdateOperation<T>(this.namespace, this.getCodec(), this.asBson(update)).filter(this.asBson(filter)).projection(this.asBson(options.getProjection())).sort(this.asBson(options.getSort())).returnOriginal(options.getReturnOriginal()).upsert(options.isUpsert()));
    }

    @Override
    public void dropCollection() {
        this.executor.execute(new DropCollectionOperation(this.namespace));
    }

    @Override
    public void createIndex(Object key) {
        this.createIndex(key, new CreateIndexOptions());
    }

    @Override
    public void createIndex(Object key, CreateIndexOptions createIndexOptions) {
        this.executor.execute(new CreateIndexOperation(this.getNamespace(), this.asBson(key)).name(createIndexOptions.getName()).background(createIndexOptions.isBackground()).unique(createIndexOptions.isUnique()).sparse(createIndexOptions.isSparse()).expireAfterSeconds(createIndexOptions.getExpireAfterSeconds()).version(createIndexOptions.getVersion()).weights(this.asBson(createIndexOptions.getWeights())).defaultLanguage(createIndexOptions.getDefaultLanguage()).languageOverride(createIndexOptions.getLanguageOverride()).textIndexVersion(createIndexOptions.getTextIndexVersion()).twoDSphereIndexVersion(createIndexOptions.getTwoDSphereIndexVersion()).bits(createIndexOptions.getBits()).min(createIndexOptions.getMin()).max(createIndexOptions.getMax()).bucketSize(createIndexOptions.getBucketSize()));
    }

    @Override
    public ListIndexesFluent<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <C> ListIndexesFluent<C> listIndexes(Class<C> clazz) {
        return new ListIndexesFluentImpl<C>(this.getNamespace(), clazz, this.codecRegistry, ReadPreference.primary(), this.executor);
    }

    @Override
    public void dropIndex(String indexName) {
        this.executor.execute(new DropIndexOperation(this.namespace, indexName));
    }

    @Override
    public void dropIndexes() {
        this.dropIndex("*");
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions());
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions renameCollectionOptions) {
        this.executor.execute(new RenameCollectionOperation(this.getNamespace(), newCollectionNamespace).dropTarget(renameCollectionOptions.isDropTarget()));
    }

    private DeleteResult delete(Object filter, boolean multi) {
        BulkWriteResult result = this.executeSingleWriteRequest(new DeleteRequest(this.asBson(filter)).multi(multi));
        if (result.wasAcknowledged()) {
            return DeleteResult.acknowledged(result.getDeletedCount());
        }
        return DeleteResult.unacknowledged();
    }

    private UpdateResult update(Object filter, Object update, UpdateOptions updateOptions, boolean multi) {
        return this.toUpdateResult(this.executeSingleWriteRequest(new UpdateRequest(this.asBson(filter), this.asBson(update), WriteRequest.Type.UPDATE).upsert(updateOptions.isUpsert()).multi(multi)));
    }

    private BulkWriteResult executeSingleWriteRequest(WriteRequest request) {
        try {
            return this.executor.execute(new MixedBulkWriteOperation(this.namespace, Arrays.asList(request), true, this.writeConcern));
        }
        catch (MongoBulkWriteException e) {
            if (e.getWriteErrors().isEmpty()) {
                throw new MongoWriteConcernException(e.getWriteConcernError(), e.getServerAddress());
            }
            throw new MongoWriteException(new WriteError(e.getWriteErrors().get(0)), e.getServerAddress());
        }
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : result.getUpserts().get(0).getId();
            return UpdateResult.acknowledged(result.getMatchedCount(), modifiedCount, upsertedId);
        }
        return UpdateResult.unacknowledged();
    }

    private Codec<T> getCodec() {
        return this.getCodec(this.clazz);
    }

    private <C> Codec<C> getCodec(Class<C> clazz) {
        return this.codecRegistry.get(clazz);
    }

    private BsonDocument asBson(Object document) {
        return BsonDocumentWrapper.asBsonDocument(document, this.codecRegistry);
    }

    private <D> List<BsonDocument> createBsonDocumentList(List<D> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (D obj : pipeline) {
            aggregateList.add(this.asBson(obj));
        }
        return aggregateList;
    }
}

