/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.Bytes;
import java.util.Iterator;
import java.util.List;
import org.bson.util.ClassMap;

public class BSONObjectSerializer {
    private ClassMap<ObjectSerializer> _serializers = new ClassMap();

    public void addObjectSerializer(Class c, ObjectSerializer o) {
        this._serializers.put(c, o);
    }

    public void serialize(Object obj, StringBuilder buf) {
        if ((obj = Bytes.applyEncodingHooks(obj)) == null) {
            buf.append(" null ");
            return;
        }
        ObjectSerializer serializer = null;
        List<Class<?>> ancestors = ClassMap.getAncestry(obj.getClass());
        Iterator<Class<?>> iterator = ancestors.iterator();
        while (iterator.hasNext() && (serializer = this._serializers.get(iterator.next())) == null) {
        }
        if (serializer == null && obj.getClass().isArray()) {
            serializer = this._serializers.get(Object[].class);
        }
        if (serializer == null) {
            throw new RuntimeException("json can't serialize type : " + obj.getClass());
        }
        serializer.serialize(obj, this, buf);
    }

    public static interface ObjectSerializer {
        public void serialize(Object var1, BSONObjectSerializer var2, StringBuilder var3);
    }
}

