/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBEncoderFactory;
import com.mongodb.DefaultDBDecoder;
import com.mongodb.DefaultDBEncoder;
import com.mongodb.WriteConcern;
import javax.net.SocketFactory;

public class MongoOptions {
    public String description;
    public int connectionsPerHost;
    public int threadsAllowedToBlockForConnectionMultiplier;
    public int maxWaitTime;
    public int connectTimeout;
    public int socketTimeout;
    public boolean socketKeepAlive;
    public boolean autoConnectRetry;
    public long maxAutoConnectRetryTime;
    @Deprecated
    public boolean slaveOk;
    public DBDecoderFactory dbDecoderFactory;
    public DBEncoderFactory dbEncoderFactory;
    public boolean safe;
    public int w;
    public int wtimeout;
    public boolean fsync;
    public boolean j;
    public SocketFactory socketFactory;

    public MongoOptions() {
        this.reset();
    }

    public void reset() {
        this.connectionsPerHost = Bytes.CONNECTIONS_PER_HOST;
        this.threadsAllowedToBlockForConnectionMultiplier = 5;
        this.maxWaitTime = 120000;
        this.connectTimeout = 0;
        this.socketTimeout = 0;
        this.socketKeepAlive = false;
        this.autoConnectRetry = false;
        this.maxAutoConnectRetryTime = 0L;
        this.slaveOk = false;
        this.safe = false;
        this.w = 0;
        this.wtimeout = 0;
        this.fsync = false;
        this.j = false;
        this.dbDecoderFactory = DefaultDBDecoder.FACTORY;
        this.dbEncoderFactory = DefaultDBEncoder.FACTORY;
        this.socketFactory = SocketFactory.getDefault();
    }

    public WriteConcern getWriteConcern() {
        if (this.w != 0 || this.wtimeout != 0 || this.fsync) {
            return new WriteConcern(this.w, this.wtimeout, this.fsync);
        }
        if (this.safe) {
            return WriteConcern.SAFE;
        }
        return WriteConcern.NORMAL;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("description=").append(this.description).append(", ");
        buf.append("connectionsPerHost=").append(this.connectionsPerHost).append(", ");
        buf.append("threadsAllowedToBlockForConnectionMultiplier=").append(this.threadsAllowedToBlockForConnectionMultiplier).append(", ");
        buf.append("maxWaitTime=").append(this.maxWaitTime).append(", ");
        buf.append("connectTimeout=").append(this.connectTimeout).append(", ");
        buf.append("socketTimeout=").append(this.socketTimeout).append(", ");
        buf.append("socketKeepAlive=").append(this.socketKeepAlive).append(", ");
        buf.append("autoConnectRetry=").append(this.autoConnectRetry).append(", ");
        buf.append("maxAutoConnectRetryTime=").append(this.maxAutoConnectRetryTime).append(", ");
        buf.append("slaveOk=").append(this.slaveOk).append(", ");
        buf.append("safe=").append(this.safe).append(", ");
        buf.append("w=").append(this.w).append(", ");
        buf.append("wtimeout=").append(this.wtimeout).append(", ");
        buf.append("fsync=").append(this.fsync).append(", ");
        buf.append("j=").append(this.j);
        return buf.toString();
    }
}

