/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBPort;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.util.SimplePool;
import java.lang.management.ManagementFactory;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBPortPool
extends SimplePool<DBPort> {
    final MongoOptions _options;
    private final Semaphore _waitingSem;
    final ServerAddress _addr;
    boolean _everWorked = false;

    DBPortPool(ServerAddress addr, MongoOptions options) {
        super("DBPortPool-" + addr.toString() + ", options = " + options.toString(), options.connectionsPerHost, options.connectionsPerHost);
        this._options = options;
        this._addr = addr;
        this._waitingSem = new Semaphore(this._options.connectionsPerHost * this._options.threadsAllowedToBlockForConnectionMultiplier);
    }

    protected long memSize(DBPort p) {
        return 0L;
    }

    @Override
    protected int pick(int iThink, boolean couldCreate) {
        int id = System.identityHashCode(Thread.currentThread());
        int s = this._availSafe.size();
        for (int i = 0; i < s; ++i) {
            DBPort p = (DBPort)this._availSafe.get(i);
            if (p._lastThread != id) continue;
            return i;
        }
        if (couldCreate) {
            return -1;
        }
        return iThink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DBPort get() {
        DBPort port = null;
        if (!this._waitingSem.tryAcquire()) {
            throw new SemaphoresOut();
        }
        try {
            port = (DBPort)this.get(this._options.maxWaitTime);
        }
        finally {
            this._waitingSem.release();
        }
        if (port == null) {
            throw new ConnectionWaitTimeOut(this._options.maxWaitTime);
        }
        port._lastThread = System.identityHashCode(Thread.currentThread());
        return port;
    }

    void gotError(Exception e) {
        DBPort temp;
        if (e instanceof ClosedByInterruptException || e instanceof InterruptedException) {
            return;
        }
        if (e instanceof SocketTimeoutException) {
            return;
        }
        Bytes.LOGGER.log(Level.WARNING, "emptying DBPortPool to " + this.getServerAddress() + " b/c of error", e);
        ArrayList<DBPort> all = new ArrayList<DBPort>();
        while ((temp = (DBPort)this.get(0L)) != null) {
            all.add(temp);
        }
        for (DBPort p : all) {
            p.close();
            this.done(p);
        }
    }

    void close() {
        this.clear();
    }

    @Override
    public void cleanup(DBPort p) {
        p.close();
    }

    @Override
    public boolean ok(DBPort t) {
        return this._addr.getSocketAddress().equals(t._addr);
    }

    @Override
    protected DBPort createNew() {
        return new DBPort(this._addr, this, this._options);
    }

    public ServerAddress getServerAddress() {
        return this._addr;
    }

    public static class ConnectionWaitTimeOut
    extends NoMoreConnection {
        private static final long serialVersionUID = -4415279469780082174L;

        ConnectionWaitTimeOut(int timeout) {
            super("Connection wait timeout after " + timeout + " ms");
        }
    }

    public static class SemaphoresOut
    extends NoMoreConnection {
        private static final long serialVersionUID = -4415279469780082174L;

        SemaphoresOut() {
            super("Out of semaphores to get db connection");
        }
    }

    public static class NoMoreConnection
    extends MongoInternalException {
        private static final long serialVersionUID = -4415279469780082174L;

        NoMoreConnection(String msg) {
            super(msg);
        }
    }

    static class Holder {
        final MongoOptions _options;
        final Map<ServerAddress, DBPortPool> _pools = Collections.synchronizedMap(new HashMap());
        final MBeanServer _server;

        Holder(MongoOptions options) {
            this._options = options;
            MBeanServer temp = null;
            try {
                temp = ManagementFactory.getPlatformMBeanServer();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._server = temp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DBPortPool get(ServerAddress addr) {
            DBPortPool p = this._pools.get(addr);
            if (p != null) {
                return p;
            }
            Map<ServerAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                p = this._pools.get(addr);
                if (p != null) {
                    return p;
                }
                p = new DBPortPool(addr, this._options);
                this._pools.put(addr, p);
                if (this._server != null) {
                    try {
                        ObjectName on = this.createObjectName(addr);
                        if (this._server.isRegistered(on)) {
                            this._server.unregisterMBean(on);
                            Bytes.LOGGER.log(Level.INFO, "multiple Mongo instances for same host, jmx numbers might be off");
                        }
                        this._server.registerMBean(p, on);
                    }
                    catch (JMException e) {
                        Bytes.LOGGER.log(Level.WARNING, "jmx registration error: " + e + " continuing...");
                    }
                    catch (AccessControlException e) {
                        Bytes.LOGGER.log(Level.WARNING, "jmx registration error: " + e + " continuing...");
                    }
                }
            }
            return p;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Map<ServerAddress, DBPortPool> map = this._pools;
            synchronized (map) {
                for (DBPortPool p : this._pools.values()) {
                    p.close();
                    try {
                        ObjectName on = this.createObjectName(p._addr);
                        if (!this._server.isRegistered(on)) continue;
                        this._server.unregisterMBean(on);
                    }
                    catch (JMException e) {
                        Bytes.LOGGER.log(Level.WARNING, "jmx de-registration error, continuing", e);
                    }
                }
            }
        }

        private ObjectName createObjectName(ServerAddress addr) throws MalformedObjectNameException {
            return new ObjectName("com.mongodb:type=ConnectionPool,host=" + addr.toString().replace(":", ",port=") + ",instance=" + this.hashCode());
        }
    }
}

