/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BaseCluster;
import com.mongodb.ChangeEvent;
import com.mongodb.ChangeListener;
import com.mongodb.ClusterConnectionMode;
import com.mongodb.ClusterDescription;
import com.mongodb.ClusterListener;
import com.mongodb.ClusterSettings;
import com.mongodb.ClusterType;
import com.mongodb.ClusterableServer;
import com.mongodb.ClusterableServerFactory;
import com.mongodb.Loggers;
import com.mongodb.ServerAddress;
import com.mongodb.ServerConnectionState;
import com.mongodb.ServerDescription;
import com.mongodb.ServerType;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.bson.types.ObjectId;
import org.bson.util.Assertions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class MultiServerCluster
extends BaseCluster {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private ClusterType clusterType;
    private String replicaSetName;
    private ObjectId maxElectionId;
    private Integer maxSetVersion;
    private final ConcurrentMap<ServerAddress, ServerTuple> addressToServerTupleMap = new ConcurrentHashMap<ServerAddress, ServerTuple>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiServerCluster(String clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, ClusterListener clusterListener) {
        super(clusterId, settings, serverFactory, clusterListener);
        Assertions.isTrue("connection mode is multiple", settings.getMode() == ClusterConnectionMode.Multiple);
        this.clusterType = settings.getRequiredClusterType();
        this.replicaSetName = settings.getRequiredReplicaSetName();
        LOGGER.info(String.format("Cluster created with settings %s", settings.getShortDescription()));
        MultiServerCluster multiServerCluster = this;
        synchronized (multiServerCluster) {
            for (ServerAddress serverAddress : settings.getHosts()) {
                this.addServer(serverAddress);
            }
            this.updateDescription();
        }
        this.fireChangeEvent();
    }

    @Override
    protected void connect() {
        for (ServerTuple cur : this.addressToServerTupleMap.values()) {
            cur.server.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.isClosed()) {
            MultiServerCluster multiServerCluster = this;
            synchronized (multiServerCluster) {
                for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
                    serverTuple.server.close();
                }
            }
            super.close();
        }
    }

    @Override
    protected ClusterableServer getServer(ServerAddress serverAddress) {
        Assertions.isTrue("is open", !this.isClosed());
        ServerTuple serverTuple = (ServerTuple)this.addressToServerTupleMap.get(serverAddress);
        if (serverTuple == null) {
            return null;
        }
        return serverTuple.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onChange(ChangeEvent<ServerDescription> event) {
        if (this.isClosed()) {
            return;
        }
        boolean shouldUpdateDescription = true;
        MultiServerCluster multiServerCluster = this;
        synchronized (multiServerCluster) {
            ServerDescription newDescription = event.getNewValue();
            LOGGER.fine(String.format("Handling description changed event for server %s with description %s", newDescription.getAddress(), newDescription));
            ServerTuple serverTuple = (ServerTuple)this.addressToServerTupleMap.get(newDescription.getAddress());
            if (serverTuple == null) {
                LOGGER.fine(String.format("Ignoring description changed event for removed server %s", newDescription.getAddress()));
                return;
            }
            if (event.getNewValue().isOk()) {
                if (this.clusterType == ClusterType.Unknown && newDescription.getType() != ServerType.ReplicaSetGhost) {
                    this.clusterType = newDescription.getClusterType();
                    LOGGER.info(String.format("Discovered cluster type of %s", new Object[]{this.clusterType}));
                }
                switch (this.clusterType) {
                    case ReplicaSet: {
                        shouldUpdateDescription = this.handleReplicaSetMemberChanged(newDescription);
                        break;
                    }
                    case Sharded: {
                        shouldUpdateDescription = this.handleShardRouterChanged(newDescription);
                        break;
                    }
                    case StandAlone: {
                        shouldUpdateDescription = this.handleStandAloneChanged(newDescription);
                        break;
                    }
                }
            }
            if (shouldUpdateDescription) {
                serverTuple.description = newDescription;
                this.updateDescription();
            }
        }
        if (shouldUpdateDescription) {
            this.fireChangeEvent();
        }
    }

    private boolean handleReplicaSetMemberChanged(ServerDescription newDescription) {
        if (!newDescription.isReplicaSetMember()) {
            LOGGER.severe(String.format("Expecting replica set member, but found a %s.  Removing %s from client view of cluster.", new Object[]{newDescription.getType(), newDescription.getAddress()}));
            this.removeServer(newDescription.getAddress());
            return true;
        }
        if (newDescription.getType() == ServerType.ReplicaSetGhost) {
            LOGGER.info(String.format("Server %s does not appear to be a member of an initiated replica set.", newDescription.getAddress()));
            return true;
        }
        if (this.replicaSetName == null) {
            this.replicaSetName = newDescription.getSetName();
        }
        if (!this.replicaSetName.equals(newDescription.getSetName())) {
            LOGGER.severe(String.format("Expecting replica set member from set '%s', but found one from set '%s'.  Removing %s from client view of cluster.", this.replicaSetName, newDescription.getSetName(), newDescription.getAddress()));
            this.removeServer(newDescription.getAddress());
            return true;
        }
        this.ensureServers(newDescription);
        if (newDescription.getCanonicalAddress() != null && !newDescription.getAddress().sameHost(newDescription.getCanonicalAddress())) {
            LOGGER.info(String.format("Canonical address %s does not match server address.  Removing %s from client view of cluster", newDescription.getCanonicalAddress(), newDescription.getAddress()));
            this.removeServer(newDescription.getAddress());
            return true;
        }
        if (newDescription.isPrimary()) {
            if (newDescription.getSetVersion() != null && newDescription.getElectionId() != null) {
                if (this.isStalePrimary(newDescription)) {
                    LOGGER.info(String.format("Invalidating potential primary %s whose (set version, election id) tuple of (%d, %s) is less than one already seen of (%d, %s)", newDescription.getAddress(), newDescription.getSetVersion(), newDescription.getElectionId(), this.maxSetVersion, this.maxElectionId));
                    ((ServerTuple)this.addressToServerTupleMap.get(newDescription.getAddress())).server.invalidate();
                    return false;
                }
                if (!newDescription.getElectionId().equals(this.maxElectionId)) {
                    LOGGER.info(String.format("Setting max election id to %s from replica set primary %s", newDescription.getElectionId(), newDescription.getAddress()));
                    this.maxElectionId = newDescription.getElectionId();
                }
            }
            if (newDescription.getSetVersion() != null && (this.maxSetVersion == null || newDescription.getSetVersion().compareTo(this.maxSetVersion) > 0)) {
                LOGGER.info(String.format("Setting max set version to %d from replica set primary %s", newDescription.getSetVersion(), newDescription.getAddress()));
                this.maxSetVersion = newDescription.getSetVersion();
            }
            if (this.isNotAlreadyPrimary(newDescription.getAddress())) {
                LOGGER.info(String.format("Discovered replica set primary %s", newDescription.getAddress()));
            }
            this.invalidateOldPrimaries(newDescription.getAddress());
        }
        return true;
    }

    private boolean isStalePrimary(ServerDescription newDescription) {
        if (this.maxSetVersion == null || this.maxElectionId == null) {
            return false;
        }
        return this.maxSetVersion.compareTo(newDescription.getSetVersion()) > 0 || this.maxSetVersion.equals(newDescription.getSetVersion()) && this.maxElectionId.compareTo(newDescription.getElectionId()) > 0;
    }

    private boolean isNotAlreadyPrimary(ServerAddress address) {
        ServerTuple serverTuple = (ServerTuple)this.addressToServerTupleMap.get(address);
        return serverTuple == null || !serverTuple.description.isPrimary();
    }

    private boolean handleShardRouterChanged(ServerDescription newDescription) {
        if (newDescription.getClusterType() != ClusterType.Sharded) {
            LOGGER.severe(String.format("Expecting a %s, but found a %s.  Removing %s from client view of cluster.", new Object[]{ServerType.ShardRouter, newDescription.getType(), newDescription.getAddress()}));
            this.removeServer(newDescription.getAddress());
        }
        return true;
    }

    private boolean handleStandAloneChanged(ServerDescription newDescription) {
        if (this.getSettings().getHosts().size() > 1) {
            LOGGER.severe(String.format("Expecting a single %s, but found more than one.  Removing %s from client view of cluster.", new Object[]{ServerType.StandAlone, newDescription.getAddress()}));
            this.clusterType = ClusterType.Unknown;
            this.removeServer(newDescription.getAddress());
        }
        return true;
    }

    private void addServer(ServerAddress serverAddress) {
        if (!this.addressToServerTupleMap.containsKey(serverAddress)) {
            LOGGER.info(String.format("Adding discovered server %s to client view of cluster", serverAddress));
            ClusterableServer server = this.createServer(serverAddress, new DefaultServerStateListener());
            this.addressToServerTupleMap.put(serverAddress, new ServerTuple(server, this.getConnectingServerDescription(serverAddress)));
        }
    }

    private void removeServer(ServerAddress serverAddress) {
        ServerTuple removed = (ServerTuple)this.addressToServerTupleMap.remove(serverAddress);
        if (removed != null) {
            removed.server.close();
        }
    }

    private void invalidateOldPrimaries(ServerAddress newPrimary) {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            if (serverTuple.description.getAddress().equals(newPrimary) || !serverTuple.description.isPrimary()) continue;
            LOGGER.info(String.format("Rediscovering type of existing primary %s", serverTuple.description.getAddress()));
            serverTuple.server.invalidate();
        }
    }

    private ServerDescription getConnectingServerDescription(ServerAddress serverAddress) {
        return ServerDescription.builder().state(ServerConnectionState.Connecting).address(serverAddress).build();
    }

    private void updateDescription() {
        List<ServerDescription> newServerDescriptionList = this.getNewServerDescriptionList();
        this.updateDescription(new ClusterDescription(ClusterConnectionMode.Multiple, this.clusterType, newServerDescriptionList));
    }

    private List<ServerDescription> getNewServerDescriptionList() {
        ArrayList<ServerDescription> serverDescriptions = new ArrayList<ServerDescription>();
        for (ServerTuple cur : this.addressToServerTupleMap.values()) {
            serverDescriptions.add(cur.description);
        }
        return serverDescriptions;
    }

    private void ensureServers(ServerDescription description) {
        if (description.isPrimary() || !this.hasPrimary()) {
            this.addNewHosts(description.getHosts());
            this.addNewHosts(description.getPassives());
            this.addNewHosts(description.getArbiters());
        }
        if (description.isPrimary()) {
            this.removeExtraHosts(description);
        }
    }

    private boolean hasPrimary() {
        for (ServerTuple serverTuple : this.addressToServerTupleMap.values()) {
            if (!serverTuple.description.isPrimary()) continue;
            return true;
        }
        return false;
    }

    private void addNewHosts(Set<String> hosts) {
        for (String cur : hosts) {
            try {
                this.addServer(new ServerAddress(cur));
            }
            catch (UnknownHostException e) {}
        }
    }

    private void removeExtraHosts(ServerDescription serverDescription) {
        Set<ServerAddress> allServerAddresses = this.getAllServerAddresses(serverDescription);
        for (ServerTuple cur : this.addressToServerTupleMap.values()) {
            if (allServerAddresses.contains(cur.description.getAddress())) continue;
            LOGGER.info(String.format("Server %s is no longer a member of the replica set.  Removing from client view of cluster.", cur.description.getAddress()));
            this.removeServer(cur.description.getAddress());
        }
    }

    private Set<ServerAddress> getAllServerAddresses(ServerDescription serverDescription) {
        HashSet<ServerAddress> retVal = new HashSet<ServerAddress>();
        this.addHostsToSet(serverDescription.getHosts(), retVal);
        this.addHostsToSet(serverDescription.getPassives(), retVal);
        this.addHostsToSet(serverDescription.getArbiters(), retVal);
        return retVal;
    }

    private void addHostsToSet(Set<String> hosts, Set<ServerAddress> retVal) {
        for (String host : hosts) {
            try {
                retVal.add(new ServerAddress(host));
            }
            catch (UnknownHostException e) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DefaultServerStateListener
    implements ChangeListener<ServerDescription> {
        private DefaultServerStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent<ServerDescription> event) {
            MultiServerCluster.this.onChange(event);
        }
    }

    private static final class ServerTuple {
        private final ClusterableServer server;
        private ServerDescription description;

        private ServerTuple(ClusterableServer server, ServerDescription description) {
            this.server = server;
            this.description = description;
        }
    }
}

