/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.util.OrderedSet;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DB {
    final Mongo _mongo;
    final String _name;
    final Set<DBCollection> _seenCollections = new HashSet<DBCollection>();
    protected boolean _readOnly = false;
    private com.mongodb.WriteConcern _concern;
    String _username;
    byte[] _authhash = null;

    public DB(Mongo mongo, String name) {
        this._mongo = mongo;
        this._name = name;
    }

    public abstract void requestStart();

    public abstract void requestDone();

    public abstract void requestEnsureConnection();

    protected abstract DBCollection doGetCollection(String var1);

    public final DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        if (c != null) {
            this._seenCollections.add(c);
        }
        return c;
    }

    public final DBCollection createCollection(String name, DBObject o) {
        if (o != null) {
            BasicDBObject createCmd = new BasicDBObject("create", name);
            createCmd.putAll(o);
            CommandResult result = this.command(createCmd);
            result.throwOnError();
        }
        return this.getCollection(name);
    }

    public DBCollection getCollectionFromString(String s) {
        DBCollection foo = null;
        while (s.contains(".")) {
            int idx = s.indexOf(".");
            String b = s.substring(0, idx);
            s = s.substring(idx + 1);
            foo = this.getCollection(b);
        }
        if (foo != null) {
            return foo.getCollection(s);
        }
        return this.getCollection(s);
    }

    public CommandResult command(DBObject cmd) throws MongoException {
        CommandResult res = (CommandResult)this.getCollection("$cmd").findOne(cmd);
        res._cmd = cmd;
        return res;
    }

    public CommandResult command(String cmd) throws MongoException {
        return this.command(new BasicDBObject(cmd, Boolean.TRUE));
    }

    public CommandResult doEval(String code, Object ... args) throws MongoException {
        return this.command(BasicDBObjectBuilder.start().add("$eval", code).add("args", args).get());
    }

    public Object eval(String code, Object ... args) throws MongoException {
        CommandResult res = this.doEval(code, args);
        if (res.ok()) {
            return res.get("retval");
        }
        throw new MongoException("eval failed: " + res);
    }

    public CommandResult getStats() {
        return this.command("dbstats");
    }

    public String getName() {
        return this._name;
    }

    public void setReadOnly(Boolean b) {
        this._readOnly = b;
    }

    public Set<String> getCollectionNames() throws MongoException {
        DBCollection namespaces = this.getCollection("system.namespaces");
        if (namespaces == null) {
            throw new RuntimeException("this is impossible");
        }
        Iterator<DBObject> i = namespaces.__find(new BasicDBObject(), null, 0, 0, 0);
        if (i == null) {
            return new HashSet<String>();
        }
        ArrayList<String> tables = new ArrayList<String>();
        while (i.hasNext()) {
            int idx;
            DBObject o = i.next();
            if (o.get("name") == null) {
                throw new MongoException("how is name null : " + o);
            }
            String n = o.get("name").toString();
            String root = n.substring(0, idx = n.indexOf("."));
            if (!root.equals(this._name) || n.indexOf("$") >= 0) continue;
            String table = n.substring(idx + 1);
            tables.add(table);
        }
        Collections.sort(tables);
        return new OrderedSet<String>(tables);
    }

    public boolean collectionExists(String collectionName) {
        if (collectionName == null || "".equals(collectionName)) {
            return false;
        }
        Set<String> collections = this.getCollectionNames();
        if (collections.size() == 0) {
            return false;
        }
        for (String collection : collections) {
            if (!collectionName.equalsIgnoreCase(collection)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this._name;
    }

    public void resetIndexCache() {
        for (DBCollection c : this._seenCollections) {
            c.resetIndexCache();
        }
    }

    public CommandResult getLastError() throws MongoException {
        return this.command(new BasicDBObject("getlasterror", (Object)1));
    }

    public CommandResult getLastError(com.mongodb.WriteConcern concern) throws MongoException {
        return this.command(concern.getCommand());
    }

    public CommandResult getLastError(int w, int wtimeout, boolean fsync) throws MongoException {
        return this.command(new com.mongodb.WriteConcern(w, wtimeout, fsync).getCommand());
    }

    public void setWriteConcern(com.mongodb.WriteConcern concern) {
        if (concern == null) {
            throw new IllegalArgumentException();
        }
        this._concern = concern;
    }

    public com.mongodb.WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._mongo.getWriteConcern();
    }

    public void dropDatabase() throws MongoException {
        CommandResult res = this.command(new BasicDBObject("dropDatabase", (Object)1));
        res.throwOnError();
    }

    public boolean isAuthenticated() {
        return this._username != null;
    }

    public boolean authenticate(String username, char[] passwd) throws MongoException {
        if (username == null) {
            throw new NullPointerException("username can't be null");
        }
        if (this._username != null) {
            throw new IllegalStateException("can't call authenticate twice on the same DBObject");
        }
        String hash = this._hash(username, passwd);
        if (!this._doauth(username, hash.getBytes())) {
            return false;
        }
        this._username = username;
        this._authhash = hash.getBytes();
        return true;
    }

    DBObject _authCommand(String nonce) {
        if (this._username == null || this._authhash == null) {
            throw new IllegalStateException("no auth info!");
        }
        return DB._authCommand(nonce, this._username, this._authhash);
    }

    static DBObject _authCommand(String nonce, String username, byte[] hash) {
        String key = nonce + username + new String(hash);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("authenticate", (Object)1);
        cmd.put("user", (Object)username);
        cmd.put("nonce", (Object)nonce);
        cmd.put("key", (Object)Util.hexMD5(key.getBytes()));
        return cmd;
    }

    private boolean _doauth(String username, byte[] hash) {
        CommandResult res = this.command(new BasicDBObject("getnonce", (Object)1));
        if (!res.ok()) {
            throw new MongoException("Error - unable to get nonce value for authentication.");
        }
        DBObject cmd = DB._authCommand(res.getString("nonce"), username, hash);
        res = this.command(cmd);
        return res.ok();
    }

    public void addUser(String username, char[] passwd) {
        DBCollection c = this.getCollection("system.users");
        DBObject o = c.findOne(new BasicDBObject("user", username));
        if (o == null) {
            o = new BasicDBObject("user", username);
        }
        o.put("pwd", this._hash(username, passwd));
        c.save(o);
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    public CommandResult getPreviousError() throws MongoException {
        return this.command(new BasicDBObject("getpreverror", (Object)1));
    }

    public void resetError() throws MongoException {
        this.command(new BasicDBObject("reseterror", (Object)1));
    }

    public void forceError() throws MongoException {
        this.command(new BasicDBObject("forceerror", (Object)1));
    }

    public Mongo getMongo() {
        return this._mongo;
    }

    public DB getSisterDB(String name) {
        return this._mongo.getDB(name);
    }

    @Deprecated
    public static class WriteConcern {
        public static final com.mongodb.WriteConcern NONE = com.mongodb.WriteConcern.NONE;
        public static final com.mongodb.WriteConcern NORMAL = com.mongodb.WriteConcern.NORMAL;
        public static final com.mongodb.WriteConcern STRICT = com.mongodb.WriteConcern.STRICT;
    }
}

