/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.util.WeakBag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.DynamicMBean;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimplePool<T>
implements DynamicMBean {
    static final boolean TRACK_LEAKS = Boolean.getBoolean("MONGO-TRACKLEAKS");
    static final long _sleepTime = 2L;
    protected final String _name;
    protected final int _maxToKeep;
    protected final int _maxTotal;
    protected final boolean _trackLeaks;
    protected final boolean _debug;
    private final List<T> _avail = new ArrayList<T>();
    protected final List<T> _availSafe = Collections.unmodifiableList(this._avail);
    private final WeakBag<T> _all = new WeakBag();
    private final Map<Integer, Throwable> _where = new HashMap<Integer, Throwable>();
    private final Semaphore _waiting = new Semaphore(0);
    private int _everCreated = 0;
    private int _trackPrintCount = 0;
    private int _consecutiveSleeps = 0;
    private static long _nextGC = 0L;

    public SimplePool(String name, int maxToKeep, int maxTotal) {
        this(name, maxToKeep, maxTotal, false, false);
    }

    public SimplePool(String name, int maxToKeep, int maxTotal, boolean trackLeaks, boolean debug) {
        this._name = name;
        this._maxToKeep = maxToKeep;
        this._maxTotal = maxTotal;
        this._trackLeaks = trackLeaks || TRACK_LEAKS;
        this._debug = debug;
    }

    protected abstract T createNew();

    public boolean ok(T t) {
        return true;
    }

    protected int pick(int iThink, boolean couldCreate) {
        return iThink;
    }

    public void done(T t) {
        this.done(t, this.ok(t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void done(T t, boolean ok) {
        List<T> list;
        if (this._trackLeaks) {
            list = this._where;
            synchronized (list) {
                this._where.remove(this._hash(t));
            }
        }
        if (!ok) {
            list = this._avail;
            synchronized (list) {
                this._all.remove(t);
            }
            return;
        }
        list = this._avail;
        synchronized (list) {
            if (this._maxToKeep < 0 || this._avail.size() < this._maxToKeep) {
                for (int i = 0; i < this._avail.size(); ++i) {
                    if (this._avail.get(i) != t) continue;
                    throw new RuntimeException("trying to put something back in the pool that's already there");
                }
                if (this._all.contains(t)) {
                    this._avail.add(t);
                    this._waiting.release();
                }
            }
        }
    }

    public void remove(T t) {
        this.done(t, false);
    }

    public T get() {
        return this.get(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long waitTime) {
        T t = this._get(waitTime);
        if (t != null) {
            this._consecutiveSleeps = 0;
            if (this._trackLeaks) {
                Throwable stack = new Throwable();
                stack.fillInStackTrace();
                Map<Integer, Throwable> map = this._where;
                synchronized (map) {
                    this._where.put(this._hash(t), stack);
                }
            }
        }
        return t;
    }

    private int _hash(T t) {
        return System.identityHashCode(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T _get(long waitTime) {
        long totalSlept = 0L;
        while (true) {
            List<T> list = this._avail;
            synchronized (list) {
                boolean couldCreate;
                boolean bl = couldCreate = this._maxTotal <= 0 || this._all.size() < this._maxTotal;
                while (this._avail.size() > 0) {
                    int toTake = this._avail.size() - 1;
                    if ((toTake = this.pick(toTake, couldCreate)) >= 0) {
                        T t = this._avail.remove(toTake);
                        if (this.ok(t)) {
                            this._debug("got an old one");
                            return t;
                        }
                        this._debug("old one was not ok");
                        this._all.remove(t);
                        continue;
                    }
                    if (couldCreate) break;
                    throw new IllegalStateException("can't pick nothing if can't create");
                }
                if (couldCreate) {
                    ++this._everCreated;
                    T t = this.createNew();
                    this._all.add(t);
                    return t;
                }
                if (this._trackLeaks && this._trackPrintCount++ % 200 == 0) {
                    this._wherePrint();
                    this._trackPrintCount = 1;
                }
            }
            if (waitTime == 0L) {
                return null;
            }
            if (waitTime > 0L && totalSlept >= waitTime) {
                return null;
            }
            if (this._consecutiveSleeps > 100 && totalSlept > 4L) {
                SimplePool._gcIfNeeded();
            }
            ++this._consecutiveSleeps;
            totalSlept += 2L;
            try {
                this._waiting.tryAcquire(2L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _wherePrint() {
        StringBuilder buf = new StringBuilder(this.toString()).append(" waiting \n");
        Map<Integer, Throwable> map = this._where;
        synchronized (map) {
            for (Throwable t : this._where.values()) {
                buf.append("--\n");
                StackTraceElement[] st = t.getStackTrace();
                for (int i = 0; i < st.length; ++i) {
                    buf.append("  ").append(st[i]).append("\n");
                }
                buf.append("----\n");
            }
        }
        System.out.println(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear() {
        this._avail.clear();
        this._all.clear();
        Map<Integer, Throwable> map = this._where;
        synchronized (map) {
            this._where.clear();
        }
    }

    public int total() {
        return this._all.size();
    }

    public int inUse() {
        return this._all.size() - this._avail.size();
    }

    public Iterator<T> getAll() {
        return this._all.getAll().iterator();
    }

    public int available() {
        if (this._maxTotal <= 0) {
            throw new IllegalStateException("this pool has an infinite number of things available");
        }
        return this._maxTotal - this.inUse();
    }

    public int everCreated() {
        return this._everCreated;
    }

    private void _debug(String msg) {
        if (this._debug) {
            System.out.println("SimplePool [" + this._name + "] : " + msg);
        }
    }

    public int maxToKeep() {
        return this._maxToKeep;
    }

    @Override
    public Object getAttribute(String attribute) {
        if (attribute.equals("name")) {
            return this._name;
        }
        if (attribute.equals("size")) {
            return this._maxToKeep;
        }
        if (attribute.equals("available")) {
            return this.available();
        }
        if (attribute.equals("inUse")) {
            return this.inUse();
        }
        if (attribute.equals("everCreated")) {
            return this._everCreated;
        }
        System.err.println("com.mongo.util.SimplePool unknown attribute: " + attribute);
        throw new RuntimeException("unknown attribute: " + attribute);
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList l = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String name = attributes[i];
            l.add(new Attribute(name, this.getAttribute(name)));
        }
        return l;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.getClass().getName(), this._name, new MBeanAttributeInfo[]{new MBeanAttributeInfo("name", "java.lang.String", "name of pool", true, false, false), new MBeanAttributeInfo("size", "java.lang.Integer", "total size of pool", true, false, false), new MBeanAttributeInfo("available", "java.lang.Integer", "total connections available", true, false, false), new MBeanAttributeInfo("inUse", "java.lang.Integer", "number connections in use right now", true, false, false), new MBeanAttributeInfo("everCreated", "java.lang.Integer", "numbe connections ever created", true, false, false)}, null, null, null);
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) {
        throw new RuntimeException("not allowed to invoke anything");
    }

    @Override
    public void setAttribute(Attribute attribute) {
        throw new RuntimeException("not allowed to set anything");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new RuntimeException("not allowed to set anything");
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("pool: ").append(this._name).append(" maxToKeep: ").append(this._maxToKeep).append(" maxTotal: ").append(this._maxToKeep).append(" where ").append(this._where.size()).append(" avail ").append(this._avail.size()).append(" all ").append(this._all.size());
        return buf.toString();
    }

    private static void _gcIfNeeded() {
        long now = System.currentTimeMillis();
        if (now < _nextGC) {
            return;
        }
        _nextGC = now + 5000L;
        System.gc();
    }
}

