/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBCallback;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ServerError;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.bson.BSONCallback;
import org.bson.BSONDecoder;
import org.bson.io.Bits;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Response {
    final DBCollection _collection;
    final int _len;
    final int _id;
    final int _responseTo;
    final int _operation;
    final int _flags;
    final long _cursor;
    final int _startingFrom;
    final int _num;
    final List<DBObject> _objects;
    static ThreadLocal<BSONDecoder> TL = new ThreadLocal<BSONDecoder>(){

        @Override
        protected BSONDecoder initialValue() {
            return new BSONDecoder();
        }
    };

    Response(DBCollection collection, InputStream in) throws IOException {
        int temp;
        this._collection = collection;
        byte[] b = new byte[16];
        for (int x = 0; x < b.length; x += temp) {
            temp = in.read(b, x, b.length - x);
            if (temp >= 0) continue;
            throw new IOException("socket closed but didn't finish reading message");
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        this._len = Bits.readInt(bin);
        this._id = Bits.readInt(bin);
        this._responseTo = Bits.readInt(bin);
        this._operation = Bits.readInt(bin);
        if (this._len > 0x2000000) {
            throw new IllegalArgumentException("response too long: " + this._len);
        }
        MyInputStream user = new MyInputStream(in, this._len - 16);
        this._flags = Bits.readInt(user);
        this._cursor = Bits.readLong(user);
        this._startingFrom = Bits.readInt(user);
        this._num = Bits.readInt(user);
        this._objects = this._num < 2 ? new LinkedList<DBObject>() : new ArrayList<DBObject>(this._num);
        DBCallback c = DBCallback.FACTORY.create(this._collection);
        BSONDecoder decoder = TL.get();
        for (int i = 0; i < this._num; ++i) {
            if (user._toGo < 5) {
                throw new IOException("should have more obejcts, but only " + user._toGo + " bytes left");
            }
            c.reset();
            decoder.decode(user, (BSONCallback)c);
            this._objects.add(c.dbget());
        }
        if (user._toGo != 0) {
            throw new IOException("finished reading objects but still have: " + user._toGo + " bytes to read!' ");
        }
        if (this._num != this._objects.size()) {
            throw new RuntimeException("something is really broken");
        }
    }

    public int size() {
        return this._num;
    }

    public DBObject get(int i) {
        return this._objects.get(i);
    }

    public Iterator<DBObject> iterator() {
        return this._objects.iterator();
    }

    public boolean hasGetMore(int queryOptions) {
        if (this._cursor <= 0L) {
            return false;
        }
        if (this._num > 0) {
            return true;
        }
        if ((queryOptions & 2) == 0) {
            return false;
        }
        if ((this._flags & 8) > 0) {
            return true;
        }
        try {
            System.out.println("sleep");
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public long cursor() {
        return this._cursor;
    }

    public ServerError getError() {
        if (this._num != 1) {
            return null;
        }
        DBObject obj = this.get(0);
        Object err = obj.get("$err");
        if (err == null) {
            return null;
        }
        return new ServerError(obj);
    }

    public String toString() {
        return "flags:" + this._flags + " _cursor:" + this._cursor + " _startingFrom:" + this._startingFrom + " _num:" + this._num;
    }

    class MyInputStream
    extends InputStream {
        final InputStream _in;
        private int _toGo;

        MyInputStream(InputStream in, int max) {
            this._in = in;
            this._toGo = max;
        }

        public int available() throws IOException {
            return this._in.available();
        }

        public int read() throws IOException {
            if (this._toGo <= 0) {
                return -1;
            }
            int val = this._in.read();
            --this._toGo;
            return val;
        }

        public void close() {
            throw new RuntimeException("can't close thos");
        }
    }
}

