/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBApiLayer;
import com.mongodb.DBTCPConnector;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 2;
    final DBAddress _addr;
    final List<DBAddress> _addrs;
    final MongoOptions _options;
    final DBTCPConnector _connector;
    final Map<String, DB> _dbs = new HashMap<String, DB>();

    public static DB connect(DBAddress addr) {
        return new Mongo(addr).getDB(addr._name);
    }

    public Mongo() throws UnknownHostException, MongoException {
        this("127.0.0.1");
    }

    public Mongo(String host) throws UnknownHostException, MongoException {
        this(new DBAddress(host, "test"));
    }

    public Mongo(String host, MongoOptions options) throws UnknownHostException, MongoException {
        this(new DBAddress(host, "test"), options);
    }

    public Mongo(String host, int port) throws UnknownHostException, MongoException {
        this(new DBAddress(host, port, "test"));
    }

    public Mongo(DBAddress addr) throws MongoException {
        this(addr, new MongoOptions());
    }

    public Mongo(DBAddress addr, MongoOptions options) throws MongoException {
        this._addr = addr;
        this._addrs = null;
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addr);
        this._connector._pickInitial();
    }

    public Mongo(DBAddress left, DBAddress right) throws MongoException {
        this(left, right, new MongoOptions());
    }

    public Mongo(DBAddress left, DBAddress right, MongoOptions options) throws MongoException {
        this._addr = null;
        this._addrs = Arrays.asList(left, right);
        this._options = options;
        this._connector = new DBTCPConnector(this, this._addrs);
        this._connector._pickInitial();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB getDB(String dbname) {
        DB db = this._dbs.get(dbname);
        if (db != null) {
            return db;
        }
        Map<String, DB> map = this._dbs;
        synchronized (map) {
            db = this._dbs.get(dbname);
            if (db != null) {
                return db;
            }
            db = new DBApiLayer(dbname, this._connector);
            this._dbs.put(dbname, db);
            return db;
        }
    }

    public List<String> getDatabaseNames() throws MongoException {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        BasicDBObject res = (BasicDBObject)this.getDB("admin").command(cmd);
        if (res.getInt("ok", 0) != 1) {
            throw new MongoException("error listing databases : " + res);
        }
        BasicDBList l = (BasicDBList)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public void dropDatabase(String dbName) throws MongoException {
        this.getDB(dbName).dropDatabase();
    }

    public String getVersion() {
        return "1.2";
    }

    public String debugString() {
        return this._connector.debugString();
    }

    public String getConnectPoint() {
        return this._connector.getConnectPoint();
    }

    public DBAddress getAddress() {
        return this._connector.getAddress();
    }
}

