/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBAddress;
import com.mongodb.DBTCP;
import com.mongodb.MongoException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mongo {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 0;
    final DBAddress _addr;
    final List<DBAddress> _addrs;

    public Mongo() throws UnknownHostException, MongoException {
        this(new DBAddress("test"));
    }

    public Mongo(String host) throws UnknownHostException, MongoException {
        this(new DBAddress(host, "test"));
    }

    public Mongo(String host, int port) throws UnknownHostException, MongoException {
        this(new DBAddress(host, port, "test"));
    }

    public Mongo(DBAddress addr) throws MongoException {
        this._addr = addr;
        this._addrs = null;
    }

    public Mongo(DBAddress left, DBAddress right) throws MongoException {
        this._addr = null;
        this._addrs = Arrays.asList(left, right);
    }

    public DB getDB(String db) {
        if (this._addr != null) {
            return new DBTCP(this._addr.getSister(db));
        }
        ArrayList<DBAddress> l = new ArrayList<DBAddress>();
        for (DBAddress a : this._addrs) {
            l.add(a.getSister(db));
        }
        return new DBTCP(l);
    }

    public List<String> getDatabaseNames() throws MongoException {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("listDatabases", (Object)1);
        BasicDBObject res = (BasicDBObject)this.getDB("admin").command(cmd);
        if (res.getInt("ok", 0) != 1) {
            throw new MongoException("error listing databases : " + res);
        }
        BasicDBList l = (BasicDBList)res.get("databases");
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : l) {
            list.add(((BasicDBObject)o).getString("name"));
        }
        return list;
    }

    public void dropDatabase(String dbName) throws MongoException {
        this.getDB(dbName).dropDatabase();
    }

    public String getVersion() {
        return "1.0";
    }
}

