/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util.gridfs;

import com.mongodb.util.gridfs.GridFSChunk;
import com.mongodb.util.gridfs.GridFSObject;
import java.io.IOException;
import java.io.InputStream;

class GridFSInputStream
extends InputStream {
    protected final GridFSObject _obj;
    protected byte[] _currentChunk = null;
    protected int pos = 0;
    protected boolean endOfStream = false;

    GridFSInputStream(GridFSObject o) {
        this._obj = o;
    }

    @Override
    public int read(byte[] dest) throws IOException {
        int destPos = 0;
        if (!(this._currentChunk != null && this.pos < this._currentChunk.length || this.getNextChunk())) {
            return -1;
        }
        do {
            int spaceAvail;
            int remaining;
            int bytesToCopy = (remaining = this._currentChunk.length - this.pos) < (spaceAvail = dest.length - destPos) ? remaining : spaceAvail;
            System.arraycopy(this._currentChunk, this.pos, dest, destPos, bytesToCopy);
            this.pos += bytesToCopy;
            if ((destPos += bytesToCopy) == dest.length) {
                return destPos;
            }
            if (this.pos >= this._currentChunk.length) continue;
            return destPos;
        } while (this.getNextChunk());
        return destPos;
    }

    @Override
    public int read() throws IOException {
        if (this.endOfStream) {
            return -1;
        }
        if (!(this._currentChunk != null && this.pos < this._currentChunk.length || this.getNextChunk())) {
            return -1;
        }
        return this._currentChunk[this.pos++] & 0xFF;
    }

    protected boolean getNextChunk() {
        GridFSChunk c = this._obj.getNextChunkFromDB();
        if (c == null) {
            this._currentChunk = null;
            this.pos = 0;
            this.endOfStream = true;
            return false;
        }
        this._currentChunk = c._data;
        this.pos = 0;
        return true;
    }
}

