/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util.gridfs;

import com.mongodb.BasicDBObject;
import com.mongodb.DBAddress;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.ObjectId;
import com.mongodb.util.gridfs.GridFSChunk;
import com.mongodb.util.gridfs.GridFSObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GridFS {
    public static final String DEFAULT_MIMETYPE = "application/octet-stream";
    public static final int DEFAULT_CHUNKSIZE = 262144;
    public static final String DEFAULT_BUCKET = "fs";
    protected final Mongo _mongo;
    protected final String _bucketName;
    protected final String _metadataCollectionName;
    protected final String _chunkCollectionName;

    public GridFS(Mongo mongo) {
        this(mongo, DEFAULT_BUCKET);
    }

    public GridFS(Mongo mongo, String bucket) {
        this._mongo = mongo;
        this._bucketName = bucket;
        this._metadataCollectionName = this._bucketName + ".files";
        this._chunkCollectionName = this._bucketName + ".chunks";
    }

    public void write(GridFSObject obj) throws IOException, MongoException {
        GridFSChunk chunk;
        this._mongo.getCollection(this._chunkCollectionName).ensureIndex(new BasicDBObject("files_id", (Object)1).append("n", 1));
        long len = 0L;
        while ((chunk = obj.getNextChunkFromStream()) != null) {
            len += chunk.getSize();
            this.saveChunk(chunk);
        }
        obj.setLength(len);
        this.saveMetadata(obj);
    }

    public GridFSObject read(String filename) throws MongoException {
        DBObject o = this._mongo.getCollection(this._metadataCollectionName).findOne(new BasicDBObject("filename", filename));
        if (o == null) {
            return null;
        }
        return this.read((ObjectId)o.get("_id"));
    }

    public GridFSObject read(ObjectId id) throws MongoException {
        DBObject o = this._mongo.getCollection(this._metadataCollectionName).findOne(new BasicDBObject("_id", id));
        if (o == null) {
            return null;
        }
        return new GridFSObject(this, o);
    }

    protected DBCursor getChunkCursorForFile(ObjectId id) {
        return this._mongo.getCollection(this._chunkCollectionName).find(new BasicDBObject("files_id", id)).sort(new BasicDBObject("n", (Object)1));
    }

    protected void saveMetadata(GridFSObject obj) throws MongoException {
        this._mongo.getCollection(this._metadataCollectionName).insert(obj.getDBObject());
    }

    protected void saveChunk(GridFSChunk chunk) throws MongoException {
        this._mongo.getCollection(this._chunkCollectionName).insert(chunk.getDBObject());
    }

    public DBCursor getFileList() {
        return this._mongo.getCollection(this._metadataCollectionName).find().sort(new BasicDBObject("filename", (Object)1));
    }

    private static void printUsage() {
        System.out.println("Usage : [--bucket bucketname] action");
        System.out.println("  where  action is one of:");
        System.out.println("      list                      : lists all files in the store");
        System.out.println("      put filename              : puts the file filename into the store");
        System.out.println("      get filename1 filename2   : gets filename1 from store and sends to filename2");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1 || "--help".equals(args[0]) || "help".equals(args[0])) {
            GridFS.printUsage();
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            int c;
            String filename;
            if (args[i].equals("list")) {
                GridFS fs = new GridFS(new Mongo(new DBAddress("127.0.0.1/org.mongo.gridfstest")));
                DBCursor cur = fs.getFileList();
                System.out.printf("%-60s %-10s\n", "Filename", "Length");
                while (cur.hasNext()) {
                    DBObject o = cur.next();
                    System.out.printf("%-60s %-10d\n", o.get("filename"), ((Double)o.get("length")).longValue());
                }
            }
            if (args[i].equals("put")) {
                if (i == args.length - 1) {
                    GridFS.printUsage();
                }
                filename = args[i + 1];
                GridFS fs = new GridFS(new Mongo(new DBAddress("127.0.0.1/org.mongo.gridfstest")));
                GridFSObject fsobj = new GridFSObject(filename, new FileInputStream(new File(filename)));
                fs.write(fsobj);
                System.out.println("Saved : _id = " + fsobj.getID());
                return;
            }
            if (!args[i].equals("get")) continue;
            if (i == args.length - 1) {
                GridFS.printUsage();
            }
            filename = args[i + 1];
            String filename2 = args[i + 2];
            GridFS fs = new GridFS(new Mongo(new DBAddress("127.0.0.1/org.mongo.gridfstest")));
            GridFSObject o = fs.read(filename);
            InputStream is = o.getInputStream();
            FileOutputStream fos = new FileOutputStream(new File(filename2));
            byte[] buffer = new byte[262144];
            int count = 0;
            while ((c = is.read(buffer)) != -1) {
                fos.write(buffer, 0, c);
                count += c;
            }
            fos.close();
            System.err.println("Wrote " + count + " bytes to " + filename2);
            return;
        }
    }
}

