/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBMessage;
import com.mongodb.DBPortPool;
import com.mongodb.MongoInternalException;
import com.mongodb.util.ThreadUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBPort {
    public static final int PORT = 27017;
    static final boolean USE_NAGLE = false;
    static final long CONN_RETRY_TIME_MS = 15000L;
    final int _hashCode;
    final InetSocketAddress _addr;
    final DBPortPool _pool;
    final Logger _logger;
    private final ByteBuffer[] _array = new ByteBuffer[]{ByteBuffer.allocateDirect(DBMessage.HEADER_LENGTH), null};
    private SocketChannel _sock;
    private static Logger _rootLogger = Logger.getLogger("db.port");

    public DBPort(InetSocketAddress addr) throws IOException {
        this(addr, null);
    }

    DBPort(InetSocketAddress addr, DBPortPool pool) throws IOException {
        this._addr = addr;
        this._pool = pool;
        this._array[0].order(Bytes.ORDER);
        this._hashCode = this._addr.hashCode();
        this._logger = Logger.getLogger(_rootLogger.getName() + "." + addr.toString());
    }

    DBMessage call(DBMessage msg, ByteBuffer response) throws IOException {
        return this.go(msg, response);
    }

    void say(DBMessage msg) throws IOException {
        this.go(msg, null);
    }

    private synchronized DBMessage go(DBMessage msg, ByteBuffer response) throws IOException {
        if (this._sock == null) {
            this._open();
        }
        this._reset(this._array[0]);
        msg.putHeader(this._array[0]);
        this._array[0].flip();
        this._array[1] = msg.getData();
        this._sock.write(this._array);
        if (this._pool != null) {
            this._pool._everWorked = true;
        }
        if (response == null) {
            return null;
        }
        this._reset(this._array[0]);
        this._sock.read(this._array[0]);
        this._array[0].flip();
        DBMessage msgResponse = new DBMessage(this._array[0], response);
        this._reset(response);
        if (msgResponse._len <= DBMessage.HEADER_LENGTH) {
            throw new IllegalArgumentException("db sent invalid length : " + msgResponse._len);
        }
        int bodySize = msgResponse._len - DBMessage.HEADER_LENGTH;
        if (bodySize > response.capacity()) {
            throw new IllegalArgumentException("db message size is too big (" + bodySize + ") max is (" + response.capacity() + ")");
        }
        response.limit(bodySize);
        while (response.remaining() > 0) {
            this._sock.read(response);
        }
        if (response.position() < response.limit()) {
            throw new MongoInternalException("buffer not fully filled");
        }
        return msgResponse;
    }

    void _reset(ByteBuffer buf) {
        buf.position(0);
        buf.limit(buf.capacity());
    }

    public void ensureOpen() throws IOException {
        if (this._sock != null) {
            return;
        }
        this._open();
    }

    void _open() throws IOException {
        long sleepTime = 100L;
        long start = System.currentTimeMillis();
        while (true) {
            IOException lastError = null;
            try {
                this._sock = SocketChannel.open();
                this._sock.connect(this._addr);
                this._sock.socket().setTcpNoDelay(true);
                return;
            }
            catch (IOException ioe) {
                lastError = new IOException("couldn't connect to [" + this._addr + "] bc:" + ioe);
                this._logger.log(Level.SEVERE, "connect fail to : " + this._addr, ioe);
                if (this._pool != null && !this._pool._everWorked) {
                    throw lastError;
                }
                long sleptSoFar = System.currentTimeMillis() - start;
                if (sleptSoFar >= 15000L) {
                    throw lastError;
                }
                if (sleepTime + sleptSoFar > 15000L) {
                    sleepTime = 15000L - sleptSoFar;
                }
                this._logger.severe("going to sleep and retry.  total sleep time after = " + (sleptSoFar + sleptSoFar) + "ms  this time:" + sleepTime + "ms");
                ThreadUtil.sleep(sleepTime);
                sleepTime *= 2L;
                continue;
            }
            break;
        }
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String host() {
        return this._addr.toString();
    }

    public String toString() {
        return "{DBPort  " + this.host() + "}";
    }

    protected void finalize() {
        if (this._sock != null) {
            try {
                this._sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._sock = null;
        }
    }
}

