/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBAddress;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import java.util.HashSet;
import java.util.Set;

public abstract class DBBase {
    final String _name;
    final Set<DBCollection> _seenCollections = new HashSet<DBCollection>();
    protected boolean _readOnly = false;

    public DBBase(String name) {
        this._name = name;
    }

    public void requestStart() {
    }

    public void requestDone() {
    }

    public void requestEnsureConnection() {
    }

    public abstract DBCollection getCollectionFromFull(String var1);

    protected abstract DBCollection doGetCollection(String var1);

    public abstract Set<String> getCollectionNames() throws MongoException;

    public abstract DBAddress getAddress();

    public abstract String getConnectPoint();

    public final DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        if (c != null) {
            this._seenCollections.add(c);
        }
        return c;
    }

    public DBCollection getCollectionFromString(String s) {
        DBCollection foo = null;
        while (s.contains(".")) {
            int idx = s.indexOf(".");
            String b = s.substring(0, idx);
            s = s.substring(idx + 1);
            foo = this.getCollection(b);
        }
        if (foo != null) {
            return foo.getCollection(s);
        }
        return this.getCollection(s);
    }

    public DBObject command(DBObject cmd) throws MongoException {
        return this.getCollection("$cmd").findOne(cmd);
    }

    public DBObject doEval(String code, Object ... args) throws MongoException {
        return this.command(BasicDBObjectBuilder.start().add("$eval", code).add("args", args).get());
    }

    public Object eval(String code, Object ... args) throws MongoException {
        DBObject res = this.doEval(code, args);
        if (res.get("ok") instanceof Number && ((Number)res.get("ok")).intValue() == 1) {
            return res.get("retval");
        }
        throw new MongoException("eval failed: " + res);
    }

    public String getName() {
        return this._name;
    }

    public void setReadOnly(Boolean b) {
        this._readOnly = b;
    }

    public String toString() {
        return this._name;
    }

    public void resetIndexCache() {
        for (DBCollection c : this._seenCollections) {
            c.resetIndexCache();
        }
    }
}

