/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.ObjectId;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class Bytes {
    static final boolean D = Boolean.getBoolean("DEBUG.DB");
    public static final ByteOrder ORDER = ByteOrder.LITTLE_ENDIAN;
    static final int BUF_SIZE = 0x500000;
    static final int CONNECTIONS_PER_HOST = Integer.parseInt(System.getProperty("MONGO.POOLSIZE", "10"));
    static final int NUM_ENCODERS;
    static final byte EOO = 0;
    static final byte NUMBER = 1;
    static final byte STRING = 2;
    static final byte OBJECT = 3;
    static final byte ARRAY = 4;
    static final byte BINARY = 5;
    static final byte UNDEFINED = 6;
    static final byte OID = 7;
    static final byte BOOLEAN = 8;
    static final byte DATE = 9;
    static final byte NULL = 10;
    static final byte REGEX = 11;
    static final byte REF = 12;
    static final byte CODE = 13;
    static final byte SYMBOL = 14;
    static final byte CODE_W_SCOPE = 15;
    static final byte NUMBER_INT = 16;
    static final byte TIMESTAMP = 17;
    static final byte NUMBER_LONG = 18;
    static final byte MINKEY = -1;
    static final byte MAXKEY = 127;
    private static final int GLOBAL_FLAG = 256;
    static final byte B_FUNC = 1;
    static final byte B_BINARY = 2;
    protected static Charset _utf8;
    protected static final int MAX_STRING = 524288;
    static final String NO_REF_HACK = "_____nodbref_____";
    static final ObjectId COLLECTION_REF_ID;

    public static byte getType(Object o) {
        if (o == null) {
            return 10;
        }
        if (o instanceof DBPointer) {
            return 12;
        }
        if (o instanceof Number) {
            return 1;
        }
        if (o instanceof String) {
            return 2;
        }
        if (o instanceof List) {
            return 4;
        }
        if (o instanceof byte[]) {
            return 5;
        }
        if (o instanceof ObjectId) {
            return 7;
        }
        if (o instanceof Boolean) {
            return 8;
        }
        if (o instanceof Date) {
            return 9;
        }
        if (o instanceof Pattern) {
            return 11;
        }
        if (o instanceof DBObject) {
            return 3;
        }
        return 0;
    }

    public static boolean cameFromDB(DBObject o) {
        if (o == null) {
            return false;
        }
        if (o.get("_id") == null) {
            return false;
        }
        return o.get("_ns") != null;
    }

    public static int patternFlags(String flags) {
        flags = flags.toLowerCase();
        int fint = 0;
        for (int i = 0; i < flags.length(); ++i) {
            Flag flag = Flag.getByCharacter(flags.charAt(i));
            if (flag != null) {
                fint |= flag.javaFlag;
                if (flag.unsupported == null) continue;
                Bytes._warnUnsupported(flag.unsupported);
                continue;
            }
            throw new IllegalArgumentException("unrecognized flag: " + flags.charAt(i));
        }
        return fint;
    }

    public static String patternFlags(int flags) {
        Flag[] f = Flag.values();
        byte[] b = new byte[f.length];
        int count = 0;
        for (Flag flag : f) {
            if ((flags & flag.javaFlag) <= 0) continue;
            b[count++] = (byte)flag.flagChar;
            flags -= flag.javaFlag;
        }
        if (flags > 0) {
            throw new IllegalArgumentException("some flags could not be recognized.");
        }
        Arrays.sort(b);
        return new String(b, 0, count);
    }

    private static void _warnUnsupported(String flag) {
        System.out.println("flag " + flag + " not supported by db.");
    }

    static {
        Runtime r = Runtime.getRuntime();
        int numBufs = (int)(r.maxMemory() / 0x500000L);
        if ((numBufs /= 5) > CONNECTIONS_PER_HOST) {
            numBufs = CONNECTIONS_PER_HOST;
        }
        if (numBufs == 0) {
            throw new IllegalStateException("the mongo driver doesn't have enough memory to create its buffers");
        }
        NUM_ENCODERS = numBufs;
        _utf8 = Charset.forName("UTF-8");
        COLLECTION_REF_ID = new ObjectId(-1L, -1);
    }

    private static enum Flag {
        CANON_EQ(128, 'c', "Pattern.CANON_EQ"),
        UNIX_LINES(1, 'd', "Pattern.UNIX_LINES"),
        GLOBAL(256, 'g', null),
        CASE_INSENSITIVE(2, 'i', null),
        MULTILINE(8, 'm', null),
        DOTALL(32, 's', "Pattern.DOTALL"),
        LITERAL(16, 't', "Pattern.LITERAL"),
        UNICODE_CASE(64, 'u', "Pattern.UNICODE_CASE"),
        COMMENTS(4, 'x', null);

        private static final Map<Character, Flag> byCharacter;
        public final int javaFlag;
        public final char flagChar;
        public final String unsupported;

        public static Flag getByCharacter(char ch) {
            return byCharacter.get(Character.valueOf(ch));
        }

        private Flag(int f, char ch, String u) {
            this.javaFlag = f;
            this.flagChar = ch;
            this.unsupported = u;
        }

        static {
            byCharacter = new HashMap<Character, Flag>();
            for (Flag flag : Flag.values()) {
                byCharacter.put(Character.valueOf(flag.flagChar), flag);
            }
        }
    }
}

