/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBAddress;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.util.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public abstract class DB {
    final String _name;
    final Set<DBCollection> _seenCollections = new HashSet<DBCollection>();
    protected boolean _readOnly = false;
    private WriteConcern _concern = WriteConcern.NORMAL;

    public DB(String name) {
        this._name = name;
    }

    public void requestStart() {
    }

    public void requestDone() {
    }

    public void requestEnsureConnection() {
    }

    public abstract DBCollection getCollectionFromFull(String var1);

    protected abstract DBCollection doGetCollection(String var1);

    public abstract Set<String> getCollectionNames() throws MongoException;

    public abstract DBAddress getAddress();

    public abstract String getConnectPoint();

    public final DBCollection getCollection(String name) {
        DBCollection c = this.doGetCollection(name);
        if (c != null) {
            this._seenCollections.add(c);
        }
        return c;
    }

    public final DBCollection createCollection(String name, DBObject o) {
        if (o != null) {
            BasicDBObject createCmd = new BasicDBObject("create", name);
            createCmd.putAll(o);
            DBObject result = this.command(createCmd);
            if (((Number)result.get("ok")).intValue() != 1) {
                throw new MongoException("getCollection failed: " + result.toString());
            }
        }
        return this.getCollection(name);
    }

    public DBCollection getCollectionFromString(String s) {
        DBCollection foo = null;
        while (s.contains(".")) {
            int idx = s.indexOf(".");
            String b = s.substring(0, idx);
            s = s.substring(idx + 1);
            foo = this.getCollection(b);
        }
        if (foo != null) {
            return foo.getCollection(s);
        }
        return this.getCollection(s);
    }

    public DBObject command(DBObject cmd) throws MongoException {
        return this.getCollection("$cmd").findOne(cmd);
    }

    public DBObject doEval(String code, Object ... args) throws MongoException {
        return this.command(BasicDBObjectBuilder.start().add("$eval", code).add("args", args).get());
    }

    public Object eval(String code, Object ... args) throws MongoException {
        DBObject res = this.doEval(code, args);
        if (res.get("ok") instanceof Number && ((Number)res.get("ok")).intValue() == 1) {
            return res.get("retval");
        }
        throw new MongoException("eval failed: " + res);
    }

    public String getName() {
        return this._name;
    }

    public void setReadOnly(Boolean b) {
        this._readOnly = b;
    }

    public String toString() {
        return this._name;
    }

    public void resetIndexCache() {
        for (DBCollection c : this._seenCollections) {
            c.resetIndexCache();
        }
    }

    public DBObject getLastError() throws MongoException {
        return this.command(new BasicDBObject("getlasterror", (Object)1));
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        return this._concern;
    }

    public void dropDatabase() throws MongoException {
        BasicDBObject res = (BasicDBObject)this.command(new BasicDBObject("dropDatabase", (Object)1));
        if (res.getInt("ok") != 1) {
            throw new RuntimeException("Error - unable to drop database : " + res.toString());
        }
    }

    public boolean authenticate(String username, char[] passwd) throws MongoException {
        BasicDBObject res = (BasicDBObject)this.command(new BasicDBObject("getnonce", (Object)1));
        if (res.getInt("ok") != 1) {
            throw new MongoException("Error - unable to get nonce value for authentication.");
        }
        String nonce = res.getString("nonce");
        String key = nonce + username + this._hash(username, passwd);
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("authenticate", (Object)1);
        cmd.put("user", (Object)username);
        cmd.put("nonce", (Object)nonce);
        cmd.put("key", (Object)Util.hexMD5(key.getBytes()));
        res = (BasicDBObject)this.command(cmd);
        return res.getInt("ok") == 1;
    }

    public void addUser(String username, char[] passwd) {
        DBCollection c = this.getCollection("system.users");
        DBObject o = c.findOne(new BasicDBObject("user", username));
        if (o == null) {
            o = new BasicDBObject("user", username);
        }
        o.put("pwd", this._hash(username, passwd));
        c.save(o);
    }

    String _hash(String username, char[] passwd) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(username.length() + 20 + passwd.length);
        try {
            bout.write(username.getBytes());
            bout.write(":mongo:".getBytes());
            for (int i = 0; i < passwd.length; ++i) {
                if (passwd[i] >= '\u0080') {
                    throw new IllegalArgumentException("can't handle non-ascii passwords yet");
                }
                bout.write((byte)passwd[i]);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("impossible", ioe);
        }
        return Util.hexMD5(bout.toByteArray());
    }

    public DBObject getPreviousError() throws MongoException {
        return this.command(new BasicDBObject("getpreverror", (Object)1));
    }

    public void resetError() throws MongoException {
        this.command(new BasicDBObject("reseterror", (Object)1));
    }

    public void forceError() throws MongoException {
        this.command(new BasicDBObject("forceerror", (Object)1));
    }

    static enum WriteConcern {
        NONE,
        NORMAL,
        STRICT;

    }
}

