/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import java.util.regex.Pattern;
import org.mockito.errorprone.bugpatterns.AbstractMockitoAnyForPrimitiveType;

@BugPattern(name="MockitoAnyIncorrectPrimitiveType", summary="Matcher mismatch: incorrect use of any() or anyX() to match a primitive argument", severity=BugPattern.SeverityLevel.ERROR, linkType=BugPattern.LinkType.CUSTOM, link="site.mockito.org/usage/bugpattern/MockitoAnyIncorrectPrimitiveType", explanation="Mockito relies on Java type checking to ensure that parameter matchers are type safe but there are some discrepancies between what the Java type checker allows and what Mockito expects. e.g. Java will allow anyInt() to be used as a matcher for a long parameter because an int can be widened to a long. This checker highlights those incorrect usages and suggests replacements. In Mockito 1.x this was not really an issue because the anyX() methods did not do runtime type checking of the arguments but in Mockito 2.x they do. Java will also allow any() to be used within a primitive but any() returns null and the compiler wraps that call in unboxing which leads to a NPE.")
public class MockitoAnyIncorrectPrimitiveType
extends AbstractMockitoAnyForPrimitiveType {
    private static final Pattern METHOD_NAME_PATTERN = Pattern.compile("any(Boolean|Byte|Char|Double|Float|Int|Long|Short)?");
    private static final String[] CLASS_NAMES = new String[]{"org.mockito.ArgumentMatchers", "org.mockito.Mockito", "org.mockito.Matchers"};
    private static final Matcher<ExpressionTree> METHOD_MATCHER = MethodMatchers.staticMethod().onClassAny(CLASS_NAMES).withNameMatching(METHOD_NAME_PATTERN).withParameters(new String[0]);

    @Override
    protected Matcher<? super MethodInvocationTree> matcher() {
        return METHOD_MATCHER;
    }

    @Override
    protected String formatMessage(String expectedTypeAsString, Type matcherType, String replacementName) {
        return String.format("Matcher mismatch: expected matcher for parameter of type '%s', found matcher for parameter of type '%s'", expectedTypeAsString, matcherType);
    }
}

