/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.mockftpserver.fake.filesystem.AbstractFileSystemEntry;
import org.mockftpserver.fake.filesystem.FileSystemEntry;
import org.mockftpserver.fake.filesystem.FileSystemException;

public class FileEntry
extends AbstractFileSystemEntry {
    private static final byte[] EMPTY = new byte[0];
    private byte[] bytes = EMPTY;
    private ByteArrayOutputStream out;

    public FileEntry() {
    }

    public FileEntry(String path) {
        super(path);
    }

    public FileEntry(String path, String contents) {
        super(path);
        this.setContents(contents);
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getSize() {
        return this.getCurrentBytes().length;
    }

    public void setContents(String contents) {
        byte[] newBytes = contents != null ? contents.getBytes() : EMPTY;
        this.setContentsInternal(newBytes);
    }

    public void setContents(String contents, String charset) throws UnsupportedEncodingException {
        byte[] newBytes = contents != null ? contents.getBytes(charset) : EMPTY;
        this.setContentsInternal(newBytes);
    }

    public void setContents(byte[] contents) {
        byte[] newBytes = EMPTY;
        if (contents != null) {
            newBytes = new byte[contents.length];
            System.arraycopy(contents, 0, newBytes, 0, contents.length);
        }
        this.setContentsInternal(newBytes);
    }

    public InputStream createInputStream() {
        return new ByteArrayInputStream(this.getCurrentBytes());
    }

    public OutputStream createOutputStream(boolean append) {
        if (append && this.out != null) {
            return this.out;
        }
        this.out = new ByteArrayOutputStream();
        byte[] initialContents = append ? this.bytes : EMPTY;
        try {
            this.out.write(initialContents);
        }
        catch (IOException e) {
            throw new FileSystemException(this.getPath(), null, e);
        }
        return this.out;
    }

    @Override
    public FileSystemEntry cloneWithNewPath(String path) {
        FileEntry clone = new FileEntry(path);
        clone.setLastModified(this.getLastModified());
        clone.setOwner(this.getOwner());
        clone.setGroup(this.getGroup());
        clone.setPermissions(this.getPermissions());
        clone.setContents(this.getCurrentBytes());
        return clone;
    }

    private byte[] getCurrentBytes() {
        return this.out != null ? this.out.toByteArray() : this.bytes;
    }

    private void setContentsInternal(byte[] contents) {
        this.bytes = contents;
        this.out = null;
    }

    public String toString() {
        return "File['" + this.getPath() + "' size=" + this.getSize() + " lastModified=" + this.getLastModified() + " owner=" + this.getOwner() + " group=" + this.getGroup() + " permissions=" + this.getPermissions() + "]";
    }
}

