/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.command;

import java.io.IOException;
import java.io.OutputStream;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.fake.command.AbstractFakeCommandHandler;
import org.mockftpserver.fake.filesystem.FileEntry;
import org.mockftpserver.fake.filesystem.FileSystemException;

public abstract class AbstractStoreFileCommandHandler
extends AbstractFakeCommandHandler {
    @Override
    protected void handle(Command command, Session session) {
        this.verifyLoggedIn(session);
        this.replyCodeForFileSystemException = 553;
        String filename = this.getOutputFile(command);
        String path = this.getRealPath(session, filename);
        this.verifyFileSystemCondition(!this.getFileSystem().isDirectory(path), path, "filesystem.isDirectory");
        String parentPath = this.getFileSystem().getParent(path);
        this.verifyFileSystemCondition(this.getFileSystem().isDirectory(parentPath), parentPath, "filesystem.isNotADirectory");
        String pathMustBeWritable = this.getFileSystem().exists(path) ? path : parentPath;
        this.verifyWritePermission(session, pathMustBeWritable);
        this.verifyExecutePermission(session, parentPath);
        this.sendReply(session, 150);
        session.openDataConnection();
        byte[] contents = session.readData();
        session.closeDataConnection();
        FileEntry file = (FileEntry)this.getFileSystem().getEntry(path);
        if (file == null) {
            file = new FileEntry(path);
            this.getFileSystem().add(file);
        }
        file.setPermissions(this.getUserAccount(session).getDefaultPermissionsForNewFile());
        if (contents != null && contents.length > 0) {
            OutputStream out = file.createOutputStream(this.appendToOutputFile());
            try {
                out.write(contents);
            }
            catch (IOException e) {
                this.LOG.error("Error writing to file [" + file.getPath() + "]", (Throwable)e);
                throw new FileSystemException(file.getPath(), null, e);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    this.LOG.error("Error closing OutputStream for file [" + file.getPath() + "]", (Throwable)e);
                }
            }
        }
        this.sendReply(session, 226, this.getMessageKey(), this.list(filename));
    }

    protected String getOutputFile(Command command) {
        return command.getRequiredParameter(0);
    }

    protected boolean appendToOutputFile() {
        return false;
    }

    protected abstract String getMessageKey();
}

