/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.AttributeKey;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.dashboard.DashboardHandler;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.MediaType;
import org.mockserver.model.PortBinding;
import org.mockserver.proxy.connect.HttpConnectHandler;
import org.mockserver.responsewriter.NettyResponseWriter;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.serialization.Base64Converter;
import org.mockserver.serialization.PortBindingSerializer;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.unification.PortUnificationHandler;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    public static final AttributeKey<Boolean> PROXYING = AttributeKey.valueOf((String)"PROXYING");
    public static final AttributeKey<Set> LOCAL_HOST_HEADERS = AttributeKey.valueOf((String)"LOCAL_HOST_HEADERS");
    private MockServerLogger mockServerLogger;
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer;
    private LifeCycle server;
    private ActionHandler actionHandler;
    private DashboardHandler dashboardHandler = new DashboardHandler();

    public MockServerHandler(LifeCycle server, HttpStateHandler httpStateHandler, ActionHandler actionHandler) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
        this.portBindingSerializer = new PortBindingSerializer(this.mockServerLogger);
        this.actionHandler = actionHandler;
    }

    private static boolean isProxyingRequest(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(PROXYING).get() != null) {
            return (Boolean)ctx.channel().attr(PROXYING).get();
        }
        return false;
    }

    private static Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        if (ctx != null && ctx.channel().attr(LOCAL_HOST_HEADERS) != null && ctx.channel().attr(LOCAL_HOST_HEADERS).get() != null) {
            return (Set)ctx.channel().attr(LOCAL_HOST_HEADERS).get();
        }
        return new HashSet<String>();
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block16: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(ctx);
            try {
                KeyAndCertificateFactory.addSubjectAlternativeName((String)request.getFirstHeader(HttpHeaderNames.HOST.toString()));
                if (this.httpStateHandler.handle(request, (ResponseWriter)responseWriter, false)) break block16;
                if (request.matches("PUT", new String[]{"/mockserver/status", "/status"})) {
                    responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getLocalPorts())), "application/json");
                    break block16;
                }
                if (request.matches("PUT", new String[]{"/mockserver/bind", "/bind"})) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    if (requestedPortBindings == null) break block16;
                    try {
                        List<Integer> actualPortBindings = this.server.bindServerPorts(requestedPortBindings.getPorts());
                        responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block16;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block16;
                        }
                        throw e;
                    }
                }
                if (request.getMethod().getValue().equals("GET") && request.getPath().getValue().startsWith("/mockserver/dashboard")) {
                    this.dashboardHandler.renderDashboard(ctx, request);
                } else if (request.matches("PUT", new String[]{"/mockserver/stop", "/stop"})) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MockServerHandler.this.server.stop();
                        }
                    }).start();
                } else if (request.getMethod().getValue().equals("CONNECT")) {
                    String username = ConfigurationProperties.proxyAuthenticationUsername();
                    String password = ConfigurationProperties.proxyAuthenticationPassword();
                    if (!(username.isEmpty() || password.isEmpty() || request.containsHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString()) && request.getFirstHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString()).toLowerCase(Locale.US).startsWith("basic ") && request.getFirstHeader(HttpHeaderNames.PROXY_AUTHORIZATION.toString()).substring(6).equals(new Base64Converter().bytesToBase64String((username + ":" + password).getBytes(StandardCharsets.UTF_8))))) {
                        ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.PROXY_AUTHENTICATION_REQUIRED.code())).withHeader(HttpHeaderNames.PROXY_AUTHENTICATE.toString(), new String[]{"Basic realm=\"" + ConfigurationProperties.proxyAuthenticationRealm().replace("\"", "\\\"") + "\""}));
                    } else {
                        ctx.channel().attr(PROXYING).set((Object)Boolean.TRUE);
                        PortUnificationHandler.enableSslUpstreamAndDownstream(ctx.channel());
                        this.server.getScheduler().submit(() -> KeyAndCertificateFactory.addSubjectAlternativeName((String)request.getPath().getValue()));
                        ctx.pipeline().addLast(new ChannelHandler[]{new HttpConnectHandler(this.server, this.mockServerLogger, request.getPath().getValue(), -1)});
                        ctx.pipeline().remove((ChannelHandler)this);
                        ctx.fireChannelRead((Object)request);
                    }
                } else {
                    this.actionHandler.processAction(request, (ResponseWriter)responseWriter, ctx, MockServerHandler.getLocalAddresses(ctx), MockServerHandler.isProxyingRequest(ctx), false);
                }
            }
            catch (IllegalArgumentException iae) {
                this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setHttpRequest(request).setMessageFormat("exception processing: {} error: {}").setArguments(new Object[]{request, iae.getMessage()}));
                responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception ex) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setType(LogEntry.LogMessageType.EXCEPTION).setHttpRequest(request).setMessageFormat("exception processing " + request).setThrowable((Throwable)ex));
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(ex.getMessage()), true);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

