/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.mockserver.client.MockServerClient;
import org.mockserver.mockserver.MockServer;

public class ClientAndServer
extends MockServerClient {
    private final MockServer mockServer;

    public ClientAndServer(Integer ... ports) {
        super(new CompletableFuture());
        this.mockServer = new MockServer(ports);
        this.portFuture.complete(this.mockServer.getLocalPort());
    }

    public ClientAndServer(String remoteHost, Integer remotePort, Integer ... ports) {
        super(new CompletableFuture());
        this.mockServer = new MockServer(remotePort, remoteHost, ports);
        this.portFuture.complete(this.mockServer.getLocalPort());
    }

    public ClientAndServer startClientAndServer(List<Integer> ports) {
        return ClientAndServer.startClientAndServer(ports.toArray(new Integer[0]));
    }

    public static ClientAndServer startClientAndServer(Integer ... port) {
        return new ClientAndServer(port);
    }

    public static ClientAndServer startClientAndServer(String remoteHost, Integer remotePort, Integer ... port) {
        return new ClientAndServer(remoteHost, remotePort, port);
    }

    public boolean isRunning() {
        return this.mockServer.isRunning();
    }

    public void stop() {
        this.mockServer.stop();
        this.stop(true);
    }

    @Deprecated
    public Integer getPort() {
        return this.getLocalPort();
    }

    public Integer getLocalPort() {
        return this.mockServer.getLocalPort();
    }

    public List<Integer> getLocalPorts() {
        return this.mockServer.getLocalPorts();
    }

    public InetSocketAddress getRemoteAddress() {
        return this.mockServer.getRemoteAddress();
    }
}

