/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socks.SocksAuthResponse;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksAuthStatus;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksRequest;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.proxy.socks.SocksConnectHandler;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.unification.PortUnificationHandler;

@ChannelHandler.Sharable
public class SocksProxyHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    private final LifeCycle server;
    private final MockServerLogger mockServerLogger;

    public SocksProxyHandler(LifeCycle server, MockServerLogger mockServerLogger) {
        super(false);
        this.server = server;
        this.mockServerLogger = mockServerLogger;
    }

    protected void channelRead0(ChannelHandlerContext ctx, SocksRequest socksRequest) {
        switch (socksRequest.requestType()) {
            case INIT: {
                ctx.pipeline().addFirst(new ChannelHandler[]{new SocksCmdRequestDecoder()});
                ctx.write((Object)new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                break;
            }
            case AUTH: {
                ctx.pipeline().addFirst(new ChannelHandler[]{new SocksCmdRequestDecoder()});
                ctx.write((Object)new SocksAuthResponse(SocksAuthStatus.SUCCESS));
                break;
            }
            case CMD: {
                final SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                if (req.cmdType() == SocksCmdType.CONNECT) {
                    Channel channel = ctx.channel();
                    channel.attr(MockServerHandler.PROXYING).set((Object)Boolean.TRUE);
                    if (String.valueOf(req.port()).endsWith("80")) {
                        PortUnificationHandler.disableSslDownstream(channel);
                    } else if (String.valueOf(req.port()).endsWith("443")) {
                        PortUnificationHandler.enabledSslDownstream(channel);
                    }
                    this.server.getScheduler().submit(new Runnable(){

                        @Override
                        public void run() {
                            KeyAndCertificateFactory.addSubjectAlternativeName((String)req.host());
                        }
                    });
                    ctx.pipeline().addAfter(((Object)((Object)this)).getClass().getSimpleName() + "#0", SocksConnectHandler.class.getSimpleName() + "#0", (ChannelHandler)new SocksConnectHandler(this.server, this.mockServerLogger, req.host(), req.port()));
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.error("Exception caught by SOCKS proxy handler -> closing pipeline " + ctx.channel(), cause);
        }
        ctx.close();
    }
}

