/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import org.mockserver.callback.CallbackWebSocketServerHandler;
import org.mockserver.client.netty.proxy.ProxyConfiguration;
import org.mockserver.dashboard.DashboardWebSocketServerHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mockserver.MockServerHandler;
import org.mockserver.server.netty.codec.MockServerServerCodec;
import org.mockserver.unification.PortUnificationHandler;

@ChannelHandler.Sharable
public class MockServerUnificationInitializer
extends PortUnificationHandler {
    private CallbackWebSocketServerHandler callbackWebSocketServerHandler;
    private DashboardWebSocketServerHandler uiWebSocketServerHandler;
    private MockServerHandler mockServerHandler;

    public MockServerUnificationInitializer(LifeCycle server, HttpStateHandler httpStateHandler, ProxyConfiguration proxyConfiguration) {
        super(server, httpStateHandler.getMockServerLogger());
        this.callbackWebSocketServerHandler = new CallbackWebSocketServerHandler(httpStateHandler);
        this.uiWebSocketServerHandler = new DashboardWebSocketServerHandler(httpStateHandler);
        this.mockServerHandler = new MockServerHandler(server, httpStateHandler, proxyConfiguration);
    }

    @Override
    protected void configurePipeline(ChannelHandlerContext ctx, ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{this.callbackWebSocketServerHandler});
        pipeline.addLast(new ChannelHandler[]{this.uiWebSocketServerHandler});
        pipeline.addLast(new ChannelHandler[]{new MockServerServerCodec(this.mockServerLogger, MockServerUnificationInitializer.isSslEnabledUpstream(ctx.channel()))});
        pipeline.addLast(new ChannelHandler[]{this.mockServerHandler});
    }
}

