/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.unification;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksInitRequestDecoder;
import io.netty.handler.codec.socks.SocksMessageEncoder;
import io.netty.handler.codec.socks.SocksProtocolVersion;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashSet;
import java.util.Set;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.socks.SocksProxyHandler;
import org.mockserver.socket.NettySslContextFactory;
import org.mockserver.unification.HttpContentLengthRemover;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class PortUnificationHandler
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final AttributeKey<Boolean> SSL_ENABLED_UPSTREAM = AttributeKey.valueOf((String)"PROXY_SSL_ENABLED_UPSTREAM");
    private static final AttributeKey<Boolean> SSL_ENABLED_DOWNSTREAM = AttributeKey.valueOf((String)"SSL_ENABLED_DOWNSTREAM");
    @VisibleForTesting
    public static Logger logger = LoggerFactory.getLogger(PortUnificationHandler.class);

    public PortUnificationHandler() {
        super(false);
    }

    public static void enabledSslUpstreamAndDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_UPSTREAM).set((Object)Boolean.TRUE);
        channel.attr(SSL_ENABLED_DOWNSTREAM).set((Object)Boolean.TRUE);
    }

    public static boolean isSslEnabledUpstream(Channel channel) {
        if (channel.attr(SSL_ENABLED_UPSTREAM).get() != null) {
            return (Boolean)channel.attr(SSL_ENABLED_UPSTREAM).get();
        }
        return false;
    }

    public static void enabledSslDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_DOWNSTREAM).set((Object)Boolean.TRUE);
    }

    public static void disableSslDownstream(Channel channel) {
        channel.attr(SSL_ENABLED_DOWNSTREAM).set((Object)Boolean.FALSE);
    }

    public static boolean isSslEnabledDownstream(Channel channel) {
        if (channel.attr(SSL_ENABLED_DOWNSTREAM).get() != null) {
            return (Boolean)channel.attr(SSL_ENABLED_DOWNSTREAM).get();
        }
        return false;
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (msg.readableBytes() < 3) {
            return;
        }
        if (this.isSsl(msg)) {
            this.enableSsl(ctx, msg);
        } else if (this.isSocks(msg)) {
            this.enableSocks(ctx, msg);
        } else if (this.isHttp(msg)) {
            this.switchToHttp(ctx, msg);
        } else {
            msg.clear();
            ctx.close();
        }
        if (logger.isTraceEnabled()) {
            if (ctx.pipeline().get(LoggingHandler.class) != null) {
                ctx.pipeline().remove(LoggingHandler.class);
            }
            if (ctx.pipeline().get(SslHandler.class) != null) {
                ctx.pipeline().addAfter("SslHandler#0", "LoggingHandler#0", (ChannelHandler)new LoggingHandler(logger));
            } else {
                ctx.pipeline().addFirst(new ChannelHandler[]{new LoggingHandler(logger)});
            }
        }
    }

    private boolean isSsl(ByteBuf buf) {
        return buf.readableBytes() >= 5 && SslHandler.isEncrypted((ByteBuf)buf);
    }

    private boolean isSocks(ByteBuf msg) {
        switch (SocksProtocolVersion.valueOf((byte)msg.getByte(msg.readerIndex()))) {
            case SOCKS5: 
            case SOCKS4a: {
                break;
            }
            default: {
                return false;
            }
        }
        int numberOfAuthenticationMethods = msg.getByte(msg.readerIndex() + 1);
        block6: for (int i = 0; i < numberOfAuthenticationMethods; ++i) {
            switch (SocksAuthScheme.valueOf((byte)msg.getByte(msg.readerIndex() + 1 + i))) {
                case NO_AUTH: 
                case AUTH_PASSWORD: 
                case AUTH_GSSAPI: {
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isHttp(ByteBuf msg) {
        short letterOne = msg.getUnsignedByte(msg.readerIndex());
        short letterTwo = msg.getUnsignedByte(msg.readerIndex() + 1);
        short letterThree = msg.getUnsignedByte(msg.readerIndex() + 2);
        return letterOne == 71 && letterTwo == 69 && letterThree == 84 || letterOne == 80 && letterTwo == 79 && letterThree == 83 || letterOne == 80 && letterTwo == 85 && letterThree == 84 || letterOne == 72 && letterTwo == 69 && letterThree == 65 || letterOne == 79 && letterTwo == 80 && letterThree == 84 || letterOne == 80 && letterTwo == 65 && letterThree == 84 || letterOne == 68 && letterTwo == 69 && letterThree == 76 || letterOne == 84 && letterTwo == 82 && letterThree == 65 || letterOne == 67 && letterTwo == 79 && letterThree == 78;
    }

    private void enableSsl(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new ChannelHandler[]{NettySslContextFactory.nettySslContextFactory().createServerSslContext().newHandler(ctx.alloc())});
        PortUnificationHandler.enabledSslUpstreamAndDownstream(ctx.channel());
        ctx.pipeline().fireChannelRead((Object)msg);
    }

    private void enableSocks(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.addFirst(new ChannelHandler[]{new SocksProxyHandler()});
        pipeline.addFirst(new ChannelHandler[]{new SocksMessageEncoder()});
        pipeline.addFirst(new ChannelHandler[]{new SocksInitRequestDecoder()});
        ctx.pipeline().fireChannelRead((Object)msg);
    }

    private void switchToHttp(ChannelHandlerContext ctx, ByteBuf msg) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpServerCodec(8192, 8192, 8192));
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentDecompressor());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpContentLengthRemover());
        this.addLastIfNotPresent(pipeline, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE));
        if (logger.isDebugEnabled()) {
            this.addLastIfNotPresent(pipeline, (ChannelHandler)new LoggingHandler(logger));
        }
        this.configurePipeline(ctx, pipeline);
        pipeline.remove((ChannelHandler)this);
        ctx.channel().attr(Proxy.LOCAL_HOST_HEADERS).set(this.getLocalAddresses(ctx));
        ctx.fireChannelRead((Object)msg);
    }

    private Set<String> getLocalAddresses(ChannelHandlerContext ctx) {
        HashSet<String> localAddresses = new HashSet<String>();
        SocketAddress localAddress = ctx.channel().localAddress();
        if (localAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)localAddress;
            String portExtension = "";
            if (!(inetSocketAddress.getPort() == 443 && PortUnificationHandler.isSslEnabledUpstream(ctx.channel()) || inetSocketAddress.getPort() == 80)) {
                portExtension = ":" + inetSocketAddress.getPort();
            }
            InetAddress socketAddress = inetSocketAddress.getAddress();
            localAddresses.add(socketAddress.getHostAddress() + portExtension);
            localAddresses.add(socketAddress.getCanonicalHostName() + portExtension);
            localAddresses.add(socketAddress.getHostName() + portExtension);
            localAddresses.add("localhost" + portExtension);
            localAddresses.add("127.0.0.1" + portExtension);
        }
        return localAddresses;
    }

    private void addLastIfNotPresent(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.get(channelHandler.getClass()) == null) {
            pipeline.addLast(new ChannelHandler[]{channelHandler});
        }
    }

    protected abstract void configurePipeline(ChannelHandlerContext var1, ChannelPipeline var2);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            logger.warn("Exception caught by port unification handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

