/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.collections.CircularHashMap;
import org.mockserver.dashboard.model.DashboardLogEntryDTO;
import org.mockserver.dashboard.model.DashboardLogEntryDTOGroup;
import org.mockserver.dashboard.serializers.DashboardLogEntryDTOGroupSerializer;
import org.mockserver.dashboard.serializers.DashboardLogEntryDTOSerializer;
import org.mockserver.dashboard.serializers.Description;
import org.mockserver.dashboard.serializers.DescriptionProcessor;
import org.mockserver.dashboard.serializers.DescriptionSerializer;
import org.mockserver.dashboard.serializers.ThrowableSerializer;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.log.MockServerEventLog;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpState;
import org.mockserver.mock.RequestMatchers;
import org.mockserver.mock.listeners.MockServerLogListener;
import org.mockserver.mock.listeners.MockServerMatcherListener;
import org.mockserver.mock.listeners.MockServerMatcherNotifier;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.model.RequestDefinition;
import org.mockserver.serialization.HttpRequestSerializer;
import org.mockserver.serialization.ObjectMapperFactory;
import org.mockserver.serialization.model.ExpectationDTO;
import org.slf4j.event.Level;

@ChannelHandler.Sharable
public class DashboardWebSocketHandler
extends ChannelInboundHandlerAdapter
implements MockServerLogListener,
MockServerMatcherListener {
    private static final Predicate<DashboardLogEntryDTO> recordedRequestsPredicate = input -> input.getType() == LogEntry.LogMessageType.RECEIVED_REQUEST;
    private static final Predicate<DashboardLogEntryDTO> proxiedRequestsPredicate = input -> input.getType() == LogEntry.LogMessageType.FORWARDED_REQUEST;
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET = AttributeKey.valueOf((String)"CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI = "/_mockserver_ui_websocket";
    private static final int UI_UPDATE_ITEM_LIMIT = 100;
    private static ObjectWriter objectWriter;
    private static ObjectMapper objectMapper;
    private final boolean prettyPrint;
    private final MockServerLogger mockServerLogger;
    private final boolean sslEnabledUpstream;
    private final HttpState httpState;
    private HttpRequestSerializer httpRequestSerializer;
    private WebSocketServerHandshaker handshaker;
    private Map<ChannelOutboundInvoker, HttpRequest> clientRegistry;
    private RequestMatchers requestMatchers;
    private MockServerEventLog mockServerEventLog;
    private ThreadPoolExecutor scheduler;
    private ScheduledExecutorService throttleExecutorService;
    private Semaphore semaphore;

    public DashboardWebSocketHandler(HttpState httpState, boolean sslEnabledUpstream, boolean prettyPrint) {
        this.httpState = httpState;
        this.mockServerLogger = httpState.getMockServerLogger();
        this.sslEnabledUpstream = sslEnabledUpstream;
        this.prettyPrint = prettyPrint;
    }

    @VisibleForTesting
    public Map<ChannelOutboundInvoker, HttpRequest> getClientRegistry() {
        if (this.clientRegistry == null) {
            this.clientRegistry = new CircularHashMap(100);
        }
        return this.clientRegistry;
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        try {
            this.scheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        catch (Throwable throwable) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception creating scheduler " + throwable.getMessage()).setThrowable(throwable));
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        if (this.throttleExecutorService != null) {
            this.throttleExecutorService.shutdownNow();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).set((Object)true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get() != null && ((Boolean)ctx.channel().attr(CHANNEL_UPGRADED_FOR_UI_WEB_SOCKET).get()).booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        String webSocketURL = (this.sslEnabledUpstream ? "wss" : "ws") + "://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_UI_WEB_SOCKET_URI;
        if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("upgraded dashboard connection to support web sockets on url{}").setArguments(new Object[]{webSocketURL}));
        }
        this.handshaker = new WebSocketServerHandshakerFactory(webSocketURL, null, true, Integer.MAX_VALUE).newHandshaker((io.netty.handler.codec.http.HttpRequest)httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            this.handshaker.handshake(ctx.channel(), httpRequest, (HttpHeaders)new DefaultHttpHeaders(), ctx.channel().newPromise()).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.getClientRegistry().put((ChannelOutboundInvoker)ctx, HttpRequest.request())));
        }
        this.registerListeners();
    }

    @VisibleForTesting
    protected DashboardWebSocketHandler registerListeners() {
        if (objectWriter == null) {
            objectMapper = ObjectMapperFactory.createObjectMapper((JsonSerializer[])new JsonSerializer[]{new DashboardLogEntryDTOSerializer(), new DashboardLogEntryDTOGroupSerializer(), new DescriptionSerializer(), new ThrowableSerializer()});
            objectWriter = this.prettyPrint ? objectMapper.writerWithDefaultPrettyPrinter() : objectMapper.writer();
        }
        if (this.httpRequestSerializer == null) {
            this.httpRequestSerializer = new HttpRequestSerializer(this.mockServerLogger);
        }
        if (this.semaphore == null) {
            this.semaphore = new Semaphore(1);
        }
        if (this.throttleExecutorService == null) {
            this.throttleExecutorService = Executors.newScheduledThreadPool(1);
        }
        if (this.scheduler == null) {
            this.scheduler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardOldestPolicy());
        }
        this.throttleExecutorService.scheduleAtFixedRate(() -> {
            if (this.semaphore.availablePermits() == 0) {
                this.semaphore.release(1);
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        if (this.mockServerEventLog == null) {
            this.mockServerEventLog = this.httpState.getMockServerLog();
            this.mockServerEventLog.registerListener((MockServerLogListener)this);
            this.requestMatchers = this.httpState.getRequestMatchers();
            this.requestMatchers.registerListener((MockServerMatcherListener)this);
            this.scheduler.submit(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.updated(this.mockServerEventLog);
                this.updated(this.requestMatchers, null);
            });
        }
        return this;
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain()).addListener((GenericFutureListener)((ChannelFutureListener)future -> this.getClientRegistry().remove(ctx)));
        } else if (frame instanceof TextWebSocketFrame) {
            try {
                HttpRequest httpRequest = this.httpRequestSerializer.deserialize(((TextWebSocketFrame)frame).text());
                this.getClientRegistry().put((ChannelOutboundInvoker)ctx, httpRequest);
                this.sendUpdate((ChannelOutboundInvoker)ctx, (RequestDefinition)httpRequest);
            }
            catch (IllegalArgumentException iae) {
                this.sendMessage((ChannelOutboundInvoker)ctx, null, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"error", (Object)iae.getMessage()), 2);
            }
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(frame.getClass().getName() + " frame types not supported");
        }
    }

    private void sendMessage(ChannelOutboundInvoker ctx, RequestDefinition httpRequest, ImmutableMap<String, Object> message, int retryCount) {
        if (this.semaphore.tryAcquire()) {
            this.scheduler.submit(() -> {
                try {
                    String text = objectWriter.writeValueAsString((Object)message);
                    ctx.writeAndFlush((Object)new TextWebSocketFrame(text));
                }
                catch (JsonProcessingException jpe) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception with serialising UI data " + jpe.getMessage()).setThrowable((Throwable)jpe));
                }
            });
        } else if (retryCount >= 0) {
            this.scheduler.submit(() -> {
                try {
                    TimeUnit.MILLISECONDS.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (httpRequest != null) {
                    this.sendUpdate(ctx, httpRequest, retryCount - 1);
                } else {
                    this.sendMessage(ctx, null, message, retryCount - 1);
                }
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("web socket server caught exception").setThrowable(cause));
        }
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.requestMatchers != null) {
            this.requestMatchers.unregisterListener((MockServerMatcherListener)this);
        }
        if (this.mockServerEventLog != null) {
            this.mockServerEventLog.unregisterListener((MockServerLogListener)this);
        }
        ctx.fireChannelInactive();
    }

    public void updated(MockServerEventLog mockServerLog) {
        for (Map.Entry<ChannelOutboundInvoker, HttpRequest> registryEntry : this.getClientRegistry().entrySet()) {
            this.sendUpdate(registryEntry.getKey(), (RequestDefinition)registryEntry.getValue());
        }
    }

    public void updated(RequestMatchers requestMatchers, MockServerMatcherNotifier.Cause cause) {
        for (Map.Entry<ChannelOutboundInvoker, HttpRequest> registryEntry : this.getClientRegistry().entrySet()) {
            this.sendUpdate(registryEntry.getKey(), (RequestDefinition)registryEntry.getValue());
        }
    }

    @VisibleForTesting
    void sendUpdate(ChannelOutboundInvoker ctx, RequestDefinition httpRequest) {
        this.sendUpdate(ctx, httpRequest, 2);
    }

    private void sendUpdate(ChannelOutboundInvoker ctx, RequestDefinition httpRequest, int retryCount) {
        DescriptionProcessor activeExpectationsDescriptionProcessor = new DescriptionProcessor();
        DescriptionProcessor logMessagesDescriptionProcessor = new DescriptionProcessor();
        DescriptionProcessor recordedRequestsDescriptionProcessor = new DescriptionProcessor();
        DescriptionProcessor proxiedRequestsDescriptionProcessor = new DescriptionProcessor();
        this.mockServerEventLog.retrieveLogEntriesInReverseForUI(httpRequest, logEntry -> true, DashboardLogEntryDTO::new, reverseLogEventsStream -> {
            List activeExpectations = this.requestMatchers.retrieveRequestMatchers(httpRequest).stream().limit(100L).map(requestMatcher -> {
                JsonNode httpRequestJsonNode;
                JsonNode expectationJsonNode = objectMapper.valueToTree((Object)new ExpectationDTO(requestMatcher.getExpectation()));
                if (requestMatcher.getExpectation().getHttpRequest() instanceof OpenAPIDefinition && (httpRequestJsonNode = expectationJsonNode.get("httpRequest")) instanceof ObjectNode) {
                    ((ObjectNode)httpRequestJsonNode).set("requestMatchers", objectMapper.valueToTree((Object)requestMatcher.getHttpRequests()));
                }
                Description description = activeExpectationsDescriptionProcessor.description(requestMatcher.getExpectation().getHttpRequest(), requestMatcher.getExpectation().getId());
                return ImmutableMap.of((Object)"key", (Object)requestMatcher.getExpectation().getId(), (Object)"description", (Object)(description != null ? description : requestMatcher.getExpectation().getId()), (Object)"value", (Object)expectationJsonNode);
            }).collect(Collectors.toList());
            LinkedList proxiedRequests = new LinkedList();
            LinkedList recordedRequests = new LinkedList();
            LinkedList logMessages = new LinkedList();
            HashMap logEntryGroups = new HashMap();
            reverseLogEventsStream.forEach(logEntryDTO -> {
                if (logEntryDTO != null) {
                    if (logMessages.size() < 100) {
                        RequestDefinition[] dashboardLogEntryDTO = logEntryDTO.setDescription(logMessagesDescriptionProcessor.description(logEntryDTO));
                        if (StringUtils.isNotBlank((CharSequence)logEntryDTO.getCorrelationId()) && logEntryDTO.getType() != LogEntry.LogMessageType.TRACE) {
                            DashboardLogEntryDTOGroup logEntryGroup = (DashboardLogEntryDTOGroup)((Object)((Object)((Object)logEntryGroups.get(logEntryDTO.getCorrelationId()))));
                            if (logEntryGroup == null) {
                                logEntryGroup = new DashboardLogEntryDTOGroup(logMessagesDescriptionProcessor);
                                logEntryGroups.put(logEntryDTO.getCorrelationId(), logEntryGroup);
                                logMessages.add(logEntryGroup);
                            }
                            logEntryGroup.getLogEntryDTOS().add((DashboardLogEntryDTO)dashboardLogEntryDTO);
                        } else {
                            logMessages.add(dashboardLogEntryDTO);
                        }
                    }
                    if (recordedRequestsPredicate.test((DashboardLogEntryDTO)((Object)((Object)logEntryDTO))) && recordedRequests.size() < 100) {
                        for (RequestDefinition request : logEntryDTO.getHttpRequests()) {
                            if (request == null) continue;
                            HashMap<String, Object> entry = new HashMap<String, Object>();
                            entry.put("key", logEntryDTO.getId() + "_request");
                            Description description = recordedRequestsDescriptionProcessor.description(request);
                            if (description != null) {
                                entry.put("description", description);
                            }
                            entry.put("value", request);
                            recordedRequests.add(entry);
                        }
                    }
                    if (proxiedRequestsPredicate.test((DashboardLogEntryDTO)((Object)((Object)logEntryDTO))) && proxiedRequests.size() < 100) {
                        HashMap<String, Object> value = new HashMap<String, Object>();
                        if (logEntryDTO.getHttpRequest() != null) {
                            value.put("httpRequest", logEntryDTO.getHttpRequest());
                        }
                        if (logEntryDTO.getHttpResponse() != null) {
                            value.put("httpResponse", logEntryDTO.getHttpResponse());
                        }
                        HashMap<String, Object> entry = new HashMap<String, Object>();
                        entry.put("key", logEntryDTO.getId() + "_proxied");
                        Description description = proxiedRequestsDescriptionProcessor.description(logEntryDTO.getHttpRequest());
                        if (description != null) {
                            entry.put("description", description);
                        }
                        entry.put("value", value);
                        if (!value.isEmpty()) {
                            proxiedRequests.add(entry);
                        }
                    }
                }
            });
            this.sendMessage(ctx, httpRequest, (ImmutableMap<String, Object>)ImmutableMap.of((Object)"logMessages", logMessages, (Object)"activeExpectations", activeExpectations, (Object)"recordedRequests", recordedRequests, (Object)"proxiedRequests", proxiedRequests), retryCount);
        });
    }
}

