/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard.serializers;

import io.swagger.v3.oas.models.OpenAPI;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.dashboard.model.DashboardLogEntryDTO;
import org.mockserver.dashboard.serializers.Description;
import org.mockserver.dashboard.serializers.LogMessageDescription;
import org.mockserver.dashboard.serializers.RequestDefinitionDescription;
import org.mockserver.dashboard.serializers.RequestDefinitionObjectDescription;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.OpenAPIDefinition;
import org.mockserver.openapi.OpenAPIConverter;

public class DescriptionProcessor {
    private int maxHttpRequestLength;
    private int maxOpenAPILength;
    private int maxOpenAPIObjectLength;
    private int maxLogEventLength;

    public int getMaxHttpRequestLength() {
        return this.maxHttpRequestLength;
    }

    public int getMaxOpenAPILength() {
        return this.maxOpenAPILength;
    }

    public int getMaxOpenAPIObjectLength() {
        return this.maxOpenAPIObjectLength;
    }

    public int getMaxLogEventLength() {
        return this.maxLogEventLength;
    }

    public Description description(Object object) {
        DashboardLogEntryDTO logEntryDTO;
        Description description = null;
        if (object instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)object;
            description = new RequestDefinitionDescription(httpRequest.getMethod().getValue(), httpRequest.getPath().getValue(), this, false);
            if (description.length() >= this.maxHttpRequestLength) {
                this.maxHttpRequestLength = description.length();
            }
        } else if (object instanceof OpenAPIDefinition) {
            OpenAPIDefinition openAPIDefinition = (OpenAPIDefinition)object;
            String operationId = StringUtils.isNotBlank((CharSequence)openAPIDefinition.getOperationId()) ? openAPIDefinition.getOperationId() : "";
            String specUrlOrPayload = openAPIDefinition.getSpecUrlOrPayload().trim();
            if (specUrlOrPayload.endsWith(".json") || specUrlOrPayload.endsWith(".yaml")) {
                description = new RequestDefinitionDescription(StringUtils.substringAfterLast((String)specUrlOrPayload, (String)"/"), operationId, this, true);
                if (description.length() >= this.maxOpenAPILength) {
                    this.maxOpenAPILength = description.length();
                }
            } else {
                OpenAPI openAPI = OpenAPIConverter.buildOpenAPI((String)specUrlOrPayload);
                description = new RequestDefinitionObjectDescription("spec:", openAPI, operationId, this);
                if (description.length() >= this.maxOpenAPIObjectLength) {
                    this.maxOpenAPIObjectLength = description.length();
                }
            }
        } else if (object instanceof DashboardLogEntryDTO && (description = new LogMessageDescription(StringUtils.substringAfter((String)(logEntryDTO = (DashboardLogEntryDTO)((Object)object)).getTimestamp(), (String)"-"), logEntryDTO.getType().name(), this)).length() >= this.maxLogEventLength) {
            this.maxLogEventLength = description.length();
        }
        return description;
    }
}

