/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.responsewriter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.mockserver.Version;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.responsewriter.ResponseWriter;
import org.mockserver.scheduler.Scheduler;
import org.slf4j.event.Level;

public class NettyResponseWriter
extends ResponseWriter {
    private final MockServerLogger mockServerLogger;
    private final ChannelHandlerContext ctx;
    private final Scheduler scheduler;
    private static final CORSHeaders CORS_HEADERS = new CORSHeaders();

    public NettyResponseWriter(MockServerLogger mockServerLogger, ChannelHandlerContext ctx, Scheduler scheduler) {
        this.mockServerLogger = mockServerLogger;
        this.ctx = ctx;
        this.scheduler = scheduler;
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        this.writeResponse(request, response, true);
    }

    public void writeResponse(HttpRequest request, HttpResponse response, boolean apiResponse) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            CORS_HEADERS.addCORSHeaders(request, response);
        } else if (apiResponse && ConfigurationProperties.enableCORSForAPI()) {
            CORS_HEADERS.addCORSHeaders(request, response);
        }
        if (apiResponse) {
            response.withHeader("version", new String[]{Version.getVersion()});
            String path = request.getPath().getValue();
            if (!path.startsWith("/mockserver") && !path.equals(ConfigurationProperties.livenessHttpGetPath())) {
                response.withHeader("deprecated", new String[]{"\"" + path + "\" is deprecated use \"" + "/mockserver" + path + "\" instead"});
            }
        }
        this.writeAndCloseSocket(this.ctx, request, this.addConnectionHeader(request, response));
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        boolean closeChannel = connectionOptions != null && connectionOptions.getCloseSocket() != null ? connectionOptions.getCloseSocket() : request.isKeepAlive() == null || request.isKeepAlive() == false;
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)response);
        if (closeChannel || ConfigurationProperties.alwaysCloseSocketConnections()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                Delay closeSocketDelay;
                Delay delay = closeSocketDelay = connectionOptions != null ? connectionOptions.getCloseSocketDelay() : null;
                if (closeSocketDelay == null) {
                    this.disconnectAndCloseChannel((ChannelFuture)future);
                } else {
                    this.scheduler.schedule(() -> this.disconnectAndCloseChannel((ChannelFuture)future), false, new Delay[]{closeSocketDelay});
                }
            }));
        }
    }

    private void disconnectAndCloseChannel(ChannelFuture future) {
        future.channel().disconnect().addListener(disconnectFuture -> {
            if (disconnectFuture.isSuccess()) {
                future.channel().close().addListener(closeFuture -> {
                    if (disconnectFuture.isSuccess()) {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.DEBUG).setMessageFormat("disconnected and closed socket " + future.channel().localAddress()));
                    } else {
                        this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception closing socket " + future.channel().localAddress()).setThrowable(disconnectFuture.cause()));
                    }
                });
            } else {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception disconnecting socket " + future.channel().localAddress()).setThrowable(disconnectFuture.cause()));
            }
        });
    }
}

