/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.netty.proxy.relay;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import org.mockserver.exception.ExceptionHandling;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.slf4j.event.Level;

public class DownstreamProxyRelayHandler
extends SimpleChannelInboundHandler<FullHttpResponse> {
    private final MockServerLogger mockServerLogger;
    private final Channel upstreamChannel;

    public DownstreamProxyRelayHandler(MockServerLogger mockServerLogger, Channel upstreamChannel) {
        super(false);
        this.upstreamChannel = upstreamChannel;
        this.mockServerLogger = mockServerLogger;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
        ctx.write((Object)Unpooled.EMPTY_BUFFER);
    }

    public void channelRead0(final ChannelHandlerContext ctx, final FullHttpResponse response) {
        this.upstreamChannel.writeAndFlush((Object)response).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    ctx.read();
                } else {
                    if (DownstreamProxyRelayHandler.this.isNotSocketClosedException(future.cause())) {
                        DownstreamProxyRelayHandler.this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception while returning writing " + response).setThrowable(future.cause()));
                    }
                    future.channel().close();
                }
            }
        });
    }

    private boolean isNotSocketClosedException(Throwable cause) {
        return !(cause instanceof ClosedChannelException) && !(cause instanceof ClosedSelectorException);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        ExceptionHandling.closeOnFlush((Channel)this.upstreamChannel);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandling.connectionClosedException((Throwable)cause)) {
            this.mockServerLogger.logEvent(new LogEntry().setType(LogEntry.LogMessageType.EXCEPTION).setLogLevel(Level.ERROR).setMessageFormat("exception caught by downstream relay handler -> closing pipeline " + ctx.channel()).setThrowable(cause));
        }
        ExceptionHandling.closeOnFlush((Channel)ctx.channel());
    }
}

