/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.lifecycle;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mockserver.stop.StopEventQueue;
import org.mockserver.stop.Stoppable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LifeCycle<T extends LifeCycle>
implements Stoppable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final List<Future<Channel>> channelOpenedFutures = new ArrayList<Future<Channel>>();
    protected final EventLoopGroup bossGroup = new NioEventLoopGroup();
    protected final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final SettableFuture<String> stopping = SettableFuture.create();
    protected StopEventQueue stopEventQueue = new StopEventQueue();
    protected ServerBootstrap serverBootstrap;

    @Override
    public Future<?> stop() {
        this.stopped();
        return this.stopEventQueue.stop(this, this.stopping, this.bossGroup, this.workerGroup);
    }

    public T withStopEventQueue(StopEventQueue stopEventQueue) {
        this.stopEventQueue = stopEventQueue;
        this.stopEventQueue.register(this);
        return (T)this;
    }

    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown() || !this.stopping.isDone();
    }

    public List<Integer> getPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Future<Channel> channelOpened : this.channelOpenedFutures) {
            try {
                ports.add(((InetSocketAddress)channelOpened.get(2L, TimeUnit.SECONDS).localAddress()).getPort());
            }
            catch (Exception e) {
                this.logger.trace("Exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return ports;
    }

    public int getPort() {
        for (Future<Channel> channelOpened : this.channelOpenedFutures) {
            try {
                return ((InetSocketAddress)channelOpened.get(2L, TimeUnit.SECONDS).localAddress()).getPort();
            }
            catch (Exception e) {
                this.logger.trace("Exception while retrieving port from channel future, ignoring port for this channel", (Throwable)e);
            }
        }
        return -1;
    }

    public List<Integer> bindToPorts(List<Integer> requestedPortBindings) {
        ArrayList<Integer> actualPortBindings = new ArrayList<Integer>();
        for (final Integer portToBind : requestedPortBindings) {
            try {
                final SettableFuture channelOpened = SettableFuture.create();
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        LifeCycle.this.channelOpenedFutures.add((Future<Channel>)channelOpened);
                        try {
                            Channel channel = LifeCycle.this.serverBootstrap.bind(portToBind.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) throws Exception {
                                    if (future.isSuccess()) {
                                        channelOpened.set((Object)future.channel());
                                    } else {
                                        channelOpened.setException(future.cause());
                                    }
                                }
                            }).channel();
                            int boundPort = ((InetSocketAddress)((Channel)channelOpened.get()).localAddress()).getPort();
                            LifeCycle.this.started(boundPort);
                            LifeCycle.this.logger.info("MockServer started on port: {}", (Object)boundPort);
                            channel.closeFuture().syncUninterruptibly();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e.getCause());
                        }
                    }
                }, "MockServer thread for port: " + portToBind).start();
                actualPortBindings.add(((InetSocketAddress)((Channel)channelOpened.get()).localAddress()).getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e.getCause());
            }
        }
        return actualPortBindings;
    }

    protected void started(Integer port) {
    }

    protected void stopped() {
    }
}

