/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.base.Strings;
import com.google.common.net.MediaType;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.BindException;
import java.util.List;
import org.mockserver.character.Character;
import org.mockserver.client.serialization.ExpectationSerializer;
import org.mockserver.client.serialization.HttpRequestSerializer;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.client.serialization.VerificationSequenceSerializer;
import org.mockserver.client.serialization.VerificationSerializer;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.cors.CORSHeaders;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.callback.ExpectationCallbackResponse;
import org.mockserver.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.model.Action;
import org.mockserver.model.ConnectionOptions;
import org.mockserver.model.Header;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.socket.KeyAndCertificateFactory;
import org.mockserver.verify.Verification;
import org.mockserver.verify.VerificationSequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private LogFormatter logFormatter = new LogFormatter(this.logger);
    private MockServer server;
    private RequestLogFilter requestLogFilter;
    private MockServerMatcher mockServerMatcher;
    private WebSocketClientRegistry webSocketClientRegistry;
    private ActionHandler actionHandler;
    private ExpectationSerializer expectationSerializer = new ExpectationSerializer();
    private HttpRequestSerializer httpRequestSerializer = new HttpRequestSerializer();
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private VerificationSerializer verificationSerializer = new VerificationSerializer();
    private VerificationSequenceSerializer verificationSequenceSerializer = new VerificationSequenceSerializer();
    private CORSHeaders addCORSHeaders = new CORSHeaders();

    public MockServerHandler(MockServer server, MockServerMatcher mockServerMatcher, WebSocketClientRegistry webSocketClientRegistry, RequestLogFilter requestLogFilter) {
        this.server = server;
        this.requestLogFilter = requestLogFilter;
        this.mockServerMatcher = mockServerMatcher;
        this.webSocketClientRegistry = webSocketClientRegistry;
        this.actionHandler = new ActionHandler(requestLogFilter);
    }

    protected void channelRead0(final ChannelHandlerContext ctx, final HttpRequest request) {
        block41: {
            try {
                if ((ConfigurationProperties.enableCORSForAPI() || ConfigurationProperties.enableCORSForAllResponses()) && request.getMethod().getValue().equals("OPTIONS") && !request.getFirstHeader("Origin").isEmpty()) {
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                    break block41;
                }
                if (request.matches("PUT", "/status")) {
                    List<Integer> actualPortBindings = this.server.getPorts();
                    this.writeResponse(ctx, request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                    break block41;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        this.writeResponse(ctx, request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block41;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block41;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/expectation")) {
                    for (Expectation expectation : this.expectationSerializer.deserializeArray(request.getBodyAsString())) {
                        KeyAndCertificateFactory.addSubjectAlternativeName((String)expectation.getHttpRequest().getFirstHeader(HttpHeaderNames.HOST.toString()));
                        this.mockServerMatcher.when(expectation.getHttpRequest(), expectation.getTimes(), expectation.getTimeToLive()).thenRespond(expectation.getHttpResponse()).thenForward(expectation.getHttpForward()).thenError(expectation.getHttpError()).thenCallback(expectation.getHttpClassCallback()).thenCallback(expectation.getHttpObjectCallback());
                        this.logFormatter.infoLog("creating expectation:{}", new Object[]{expectation});
                    }
                    this.writeResponse(ctx, request, HttpResponseStatus.CREATED);
                } else if (request.matches("PUT", "/clear")) {
                    HttpRequest httpRequest = null;
                    if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
                        httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                    }
                    if (request.hasQueryStringParameter("type", "expectation")) {
                        this.mockServerMatcher.clear(httpRequest);
                        this.logFormatter.infoLog("clearing expectations that match:{}", new Object[]{httpRequest});
                    } else if (request.hasQueryStringParameter("type", "log")) {
                        this.requestLogFilter.clear(httpRequest);
                        this.logFormatter.infoLog("clearing request logs that match:{}", new Object[]{httpRequest});
                    } else {
                        this.requestLogFilter.clear(httpRequest);
                        this.mockServerMatcher.clear(httpRequest);
                        this.logFormatter.infoLog("clearing expectations and request logs that match:{}", new Object[]{httpRequest});
                    }
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                } else if (request.matches("PUT", "/reset")) {
                    this.requestLogFilter.reset();
                    this.mockServerMatcher.reset();
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                    this.logFormatter.infoLog("resetting all expectations and request logs", new Object[0]);
                } else if (request.matches("PUT", "/dumpToLog")) {
                    HttpRequest httpRequest = null;
                    if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
                        httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                    }
                    this.mockServerMatcher.dumpToLog(httpRequest);
                    this.writeResponse(ctx, request, HttpResponseStatus.OK);
                } else if (request.matches("PUT", "/retrieve")) {
                    HttpRequest httpRequest = null;
                    if (!Strings.isNullOrEmpty((String)request.getBodyAsString())) {
                        httpRequest = this.httpRequestSerializer.deserialize(request.getBodyAsString());
                    }
                    if (request.hasQueryStringParameter("type", "expectation")) {
                        Expectation[] expectations = this.mockServerMatcher.retrieveExpectations(httpRequest);
                        this.writeResponse(ctx, request, HttpResponseStatus.OK, this.expectationSerializer.serialize(expectations), "application/json");
                        this.logFormatter.infoLog("retrieving expectations that match:{}", new Object[]{httpRequest});
                    } else {
                        HttpRequest[] requests = this.requestLogFilter.retrieve(httpRequest);
                        this.writeResponse(ctx, request, HttpResponseStatus.OK, this.httpRequestSerializer.serialize(requests), "application/json");
                        this.logFormatter.infoLog("retrieving requests that match:{}", new Object[]{httpRequest});
                    }
                } else if (request.matches("PUT", "/verify")) {
                    Verification verification = this.verificationSerializer.deserialize(request.getBodyAsString());
                    String result = this.requestLogFilter.verify(verification);
                    this.verifyResponse(ctx, request, result);
                    this.logFormatter.infoLog("verifying requests that match:{}", new Object[]{verification});
                } else if (request.matches("PUT", "/verifySequence")) {
                    VerificationSequence verificationSequence = this.verificationSequenceSerializer.deserialize(request.getBodyAsString());
                    String result = this.requestLogFilter.verify(verificationSequence);
                    this.verifyResponse(ctx, request, result);
                    this.logFormatter.infoLog("verifying sequence that match:{}", new Object[]{verificationSequence});
                } else if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MockServerHandler.this.server.stop();
                        }
                    }).start();
                } else {
                    Action handle = this.mockServerMatcher.retrieveAction(request);
                    if (handle instanceof HttpError) {
                        ChannelHandlerContext httpCodecContext;
                        HttpError httpError = ((HttpError)handle).applyDelay();
                        this.requestLogFilter.onRequest(request);
                        if (httpError.getResponseBytes() != null && (httpCodecContext = ctx.pipeline().context(HttpServerCodec.class)) != null) {
                            httpCodecContext.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])httpError.getResponseBytes())).awaitUninterruptibly();
                        }
                        if (httpError.getDropConnection().booleanValue()) {
                            ctx.close();
                        }
                    } else if (handle instanceof HttpObjectCallback) {
                        String clientId = ((HttpObjectCallback)handle).getClientId();
                        this.webSocketClientRegistry.registerCallbackResponseHandler(clientId, new ExpectationCallbackResponse(){

                            @Override
                            public void handle(HttpResponse response) {
                                MockServerHandler.this.requestLogFilter.onResponse(request, response);
                                MockServerHandler.this.writeResponse(ctx, request, response.withConnectionOptions(ConnectionOptions.connectionOptions().withCloseSocket(Boolean.valueOf(true))));
                                MockServerHandler.this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}", new Object[]{response, request});
                            }
                        });
                        this.requestLogFilter.onRequest(request);
                        this.webSocketClientRegistry.sendClientMessage(clientId, request);
                    } else {
                        HttpResponse response = this.actionHandler.processAction(handle, request);
                        this.writeResponse(ctx, request, response);
                        this.logFormatter.infoLog("returning response:{}" + Character.NEW_LINE + " for request:{}", new Object[]{response, request});
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                this.writeResponse(ctx, request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception e) {
                this.logger.error("Exception processing " + request, (Throwable)e);
                this.writeResponse(ctx, request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
            }
        }
    }

    private void verifyResponse(ChannelHandlerContext ctx, HttpRequest request, String result) {
        if (result.isEmpty()) {
            this.writeResponse(ctx, request, HttpResponseStatus.ACCEPTED);
        } else {
            this.writeResponse(ctx, request, HttpResponseStatus.NOT_ACCEPTABLE, result, MediaType.create((String)"text", (String)"plain").toString());
        }
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(ctx, request, responseStatus, "", "application/json");
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(Integer.valueOf(responseStatus.code())).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.updateHeader(Header.header((String)HttpHeaderNames.CONTENT_TYPE.toString(), (String[])new String[]{contentType + "; charset=utf-8"}));
        }
        if (ConfigurationProperties.enableCORSForAPI()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.writeResponse(ctx, request, response);
    }

    private void writeResponse(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (ConfigurationProperties.enableCORSForAllResponses()) {
            this.addCORSHeaders.addCORSHeaders(response);
        }
        this.addConnectionHeader(request, response);
        this.writeAndCloseSocket(ctx, request, response);
    }

    private void addConnectionHeader(HttpRequest request, HttpResponse response) {
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getKeepAliveOverride() != null) {
            if (connectionOptions.getKeepAliveOverride().booleanValue()) {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            } else {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            }
        } else if (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getSuppressConnectionHeader())) {
            if (request.isKeepAlive() != null && request.isKeepAlive().booleanValue() && (connectionOptions == null || ConnectionOptions.isFalseOrNull((Boolean)connectionOptions.getCloseSocket()))) {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.KEEP_ALIVE.toString()}));
            } else {
                response.updateHeader(Header.header((String)HttpHeaderNames.CONNECTION.toString(), (String[])new String[]{HttpHeaderValues.CLOSE.toString()}));
            }
        }
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel;
        ConnectionOptions connectionOptions = response.getConnectionOptions();
        if (connectionOptions != null && connectionOptions.getCloseSocket() != null) {
            closeChannel = connectionOptions.getCloseSocket();
        } else {
            boolean bl = closeChannel = request.isKeepAlive() == null || request.isKeepAlive() == false;
        }
        if (closeChannel) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.write((Object)response);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().contains("reset by peer") || !cause.getMessage().contains("connection was aborted")) {
            this.logger.warn("Exception caught by MockServer handler -> closing pipeline", cause);
        }
        ctx.close();
    }
}

