/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.socks.SocksAuthResponse;
import io.netty.handler.codec.socks.SocksAuthScheme;
import io.netty.handler.codec.socks.SocksAuthStatus;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdRequestDecoder;
import io.netty.handler.codec.socks.SocksCmdType;
import io.netty.handler.codec.socks.SocksInitResponse;
import io.netty.handler.codec.socks.SocksRequest;
import org.mockserver.proxy.error.Logging;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.socks.SocksConnectHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocksProxyHandler
extends SimpleChannelInboundHandler<SocksRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public SocksProxyHandler() {
        super(false);
    }

    protected void channelRead0(ChannelHandlerContext ctx, SocksRequest socksRequest) {
        switch (socksRequest.requestType()) {
            case INIT: {
                ctx.pipeline().addFirst(new ChannelHandler[]{new SocksCmdRequestDecoder()});
                ctx.write((Object)new SocksInitResponse(SocksAuthScheme.NO_AUTH));
                break;
            }
            case AUTH: {
                ctx.pipeline().addFirst(new ChannelHandler[]{new SocksCmdRequestDecoder()});
                ctx.write((Object)new SocksAuthResponse(SocksAuthStatus.SUCCESS));
                break;
            }
            case CMD: {
                SocksCmdRequest req = (SocksCmdRequest)socksRequest;
                if (req.cmdType() == SocksCmdType.CONNECT) {
                    Channel channel = ctx.channel();
                    if (req.port() == 80 || req.port() == 8080) {
                        PortUnificationHandler.disableSslDownstream(channel);
                    } else if (req.port() == 443 || req.port() == 8443) {
                        PortUnificationHandler.enabledSslDownstream(channel);
                    } else {
                        PortUnificationHandler.enabledSslDownstream(channel);
                        channel.attr(HttpProxy.ONWARD_SSL_UNKNOWN).set((Object)true);
                    }
                    SSLFactory.addSubjectAlternativeName((String)req.host());
                    ctx.pipeline().addAfter(((Object)((Object)this)).getClass().getSimpleName() + "#0", SocksConnectHandler.class.getSimpleName() + "#0", (ChannelHandler)new SocksConnectHandler());
                    ctx.pipeline().remove((ChannelHandler)this);
                    ctx.fireChannelRead((Object)socksRequest);
                    break;
                }
                ctx.close();
                break;
            }
            case UNKNOWN: {
                ctx.close();
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!Logging.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by SOCKS proxy handler -> closing pipeline " + ctx.channel(), cause);
        }
        ctx.close();
    }
}

