/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.relay;

import com.google.common.annotations.VisibleForTesting;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.mockserver.logging.LoggingHandler;
import org.mockserver.proxy.error.Logging;
import org.mockserver.proxy.http.HttpProxy;
import org.mockserver.proxy.relay.DownstreamProxyRelayHandler;
import org.mockserver.proxy.relay.UpstreamProxyRelayHandler;
import org.mockserver.proxy.unification.PortUnificationHandler;
import org.mockserver.socket.SSLFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public abstract class RelayConnectHandler<T>
extends SimpleChannelInboundHandler<T> {
    @VisibleForTesting
    public static Logger logger = LoggerFactory.getLogger(RelayConnectHandler.class);

    public void channelRead0(final ChannelHandlerContext serverCtx, final T request) throws Exception {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)serverCtx.channel().eventLoop())).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(final ChannelHandlerContext clientCtx) throws Exception {
                serverCtx.channel().writeAndFlush(RelayConnectHandler.this.successResponse(request)).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        RelayConnectHandler.this.removeCodecSupport(serverCtx);
                        ChannelPipeline downstreamPipeline = clientCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabledDownstream(serverCtx.channel())) {
                            downstreamPipeline.addLast(new ChannelHandler[]{new SslHandler(SSLFactory.createClientSSLEngine())});
                        }
                        if (logger.isDebugEnabled()) {
                            downstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler(this.getClass().getSimpleName() + "                -->")});
                        }
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        downstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                        downstreamPipeline.addLast(new ChannelHandler[]{new DownstreamProxyRelayHandler(serverCtx.channel(), logger)});
                        ChannelPipeline upstreamPipeline = serverCtx.channel().pipeline();
                        if (PortUnificationHandler.isSslEnabledUpstream(serverCtx.channel())) {
                            upstreamPipeline.addLast(new ChannelHandler[]{new SslHandler(SSLFactory.createServerSSLEngine())});
                        }
                        if (logger.isDebugEnabled()) {
                            upstreamPipeline.addLast(new ChannelHandler[]{new LoggingHandler(this.getClass().getSimpleName() + "<-- ")});
                        }
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
                        upstreamPipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
                        upstreamPipeline.addLast(new ChannelHandler[]{new UpstreamProxyRelayHandler(clientCtx.channel(), logger)});
                    }
                });
            }
        });
        final InetSocketAddress remoteSocket = this.getDownstreamSocket(serverCtx.channel());
        bootstrap.connect((SocketAddress)remoteSocket).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    RelayConnectHandler.this.failure("Connection failed to " + remoteSocket, future.cause(), serverCtx, RelayConnectHandler.this.failureResponse(request));
                }
            }
        });
    }

    private InetSocketAddress getDownstreamSocket(Channel channel) {
        if (channel.attr(HttpProxy.REMOTE_SOCKET).get() != null) {
            return (InetSocketAddress)channel.attr(HttpProxy.REMOTE_SOCKET).get();
        }
        if (channel.attr(HttpProxy.HTTP_CONNECT_SOCKET).get() != null) {
            return (InetSocketAddress)channel.attr(HttpProxy.HTTP_CONNECT_SOCKET).get();
        }
        throw new IllegalStateException("Trying to connect to remote socket but no remote socket has been set");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.failure("Exception caught by CONNECT proxy handler -> closing pipeline ", cause, ctx, this.failureResponse(null));
    }

    private void failure(String message, Throwable cause, ChannelHandlerContext ctx, Object response) {
        if (!Logging.shouldIgnoreException(cause)) {
            logger.warn(message, cause);
        }
        Channel channel = ctx.channel();
        channel.writeAndFlush(response);
        if (channel.isActive()) {
            channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    protected abstract void removeCodecSupport(ChannelHandlerContext var1);

    protected abstract Object successResponse(Object var1);

    protected abstract Object failureResponse(Object var1);

    protected void removeHandler(ChannelPipeline pipeline, Class<? extends ChannelHandler> handlerType) {
        if (pipeline.get(handlerType) != null) {
            pipeline.remove(handlerType);
        }
    }

    protected void removeHandler(ChannelPipeline pipeline, ChannelHandler channelHandler) {
        if (pipeline.toMap().containsValue(channelHandler)) {
            pipeline.remove(channelHandler);
        }
    }
}

