/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.codec;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.mappers.ContentTypeMapper;
import org.mockserver.model.Body;
import org.mockserver.model.Header;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.NottableString;

public class MockServerResponseEncoder
extends MessageToMessageEncoder<HttpResponse> {
    protected void encode(ChannelHandlerContext ctx, HttpResponse response, List<Object> out) {
        DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)(response.getStatusCode() != null ? response.getStatusCode() : 200)), this.getBody(response));
        this.setHeaders(response, defaultFullHttpResponse);
        this.setCookies(response, defaultFullHttpResponse);
        out.add(defaultFullHttpResponse);
    }

    private ByteBuf getBody(HttpResponse response) {
        ByteBuf content = Unpooled.buffer((int)0, (int)0);
        Body body = response.getBody();
        if (body != null) {
            Object bodyContents = body.getValue();
            Charset bodyCharset = body.getCharset(ContentTypeMapper.determineCharsetForMessage((HttpResponse)response));
            if (bodyContents instanceof byte[]) {
                content = Unpooled.copiedBuffer((byte[])((byte[])bodyContents));
            } else if (bodyContents instanceof String) {
                content = Unpooled.copiedBuffer((byte[])((String)bodyContents).getBytes(bodyCharset));
            } else if (body.toString() != null) {
                content = Unpooled.copiedBuffer((byte[])body.toString().getBytes(bodyCharset));
            }
        }
        return content;
    }

    private void setHeaders(HttpResponse response, DefaultFullHttpResponse httpServletResponse) {
        if (response.getHeaders() != null) {
            for (Header header : response.getHeaders()) {
                for (NottableString value : header.getValues()) {
                    httpServletResponse.headers().add(header.getName().getValue(), (Object)value.getValue());
                }
            }
        }
        if (Strings.isNullOrEmpty((String)response.getFirstHeader("Content-Type")) && response.getBody() != null && !Strings.isNullOrEmpty((String)response.getBody().toString())) {
            Charset bodyCharset = response.getBody().getCharset(null);
            String bodyContentType = response.getBody().getContentType();
            if (bodyCharset != null) {
                httpServletResponse.headers().set("Content-Type", (Object)(bodyContentType + "; charset=" + bodyCharset.name().toLowerCase()));
            } else if (bodyContentType != null) {
                httpServletResponse.headers().set("Content-Type", (Object)bodyContentType);
            }
        }
    }

    private void setCookies(HttpResponse response, DefaultFullHttpResponse httpServletResponse) {
        if (response.getCookies() != null) {
            ArrayList<DefaultCookie> cookieValues = new ArrayList<DefaultCookie>();
            for (org.mockserver.model.Cookie cookie : response.getCookies()) {
                if (this.cookieHeaderAlreadyExists(response, cookie)) continue;
                cookieValues.add(new DefaultCookie(cookie.getName().getValue(), cookie.getValue().getValue()));
            }
            for (Cookie cookie : cookieValues) {
                httpServletResponse.headers().add("Set-Cookie", (Object)ServerCookieEncoder.LAX.encode(cookie));
            }
        }
    }

    private boolean cookieHeaderAlreadyExists(HttpResponse response, org.mockserver.model.Cookie cookieValue) {
        List setCookieHeaders = response.getHeader("Set-Cookie");
        setCookieHeaders.addAll(response.getHeader("Set-Cookie".toLowerCase()));
        for (String setCookieHeader : setCookieHeaders) {
            String existingCookieName = ClientCookieDecoder.LAX.decode(setCookieHeader).name();
            String existingCookieValue = ClientCookieDecoder.LAX.decode(setCookieHeader).value();
            if (!existingCookieName.equalsIgnoreCase(cookieValue.getName().getValue()) || !existingCookieValue.equalsIgnoreCase(cookieValue.getValue().getValue())) continue;
            return true;
        }
        return false;
    }
}

