/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.testing.tls;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.Socket;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.KeyStoreFactory;

public class SSLSocketFactory {
    public static SSLSocketFactory sslSocketFactory() {
        return new SSLSocketFactory();
    }

    @VisibleForTesting
    public synchronized SSLSocket wrapSocket(Socket socket) throws IOException {
        javax.net.ssl.SSLSocketFactory sslSocketFactory = new KeyStoreFactory(new MockServerLogger()).sslContext().getSocketFactory();
        SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostAddress(), socket.getPort(), true);
        sslSocket.setUseClientMode(true);
        sslSocket.startHandshake();
        return sslSocket;
    }

    @VisibleForTesting
    public synchronized SSLServerSocket wrapSocket() throws IOException {
        SSLServerSocketFactory sslSocketFactory = new KeyStoreFactory(new MockServerLogger()).sslContext().getServerSocketFactory();
        return (SSLServerSocket)sslSocketFactory.createServerSocket(0);
    }
}

