/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.testing.integration.mock;

import com.google.common.collect.ImmutableList;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.NettyHttpClient;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.MatcherBuilder;
import org.mockserver.model.Header;
import org.mockserver.model.Headers;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.KeyToMultiValue;
import org.mockserver.model.NottableString;
import org.mockserver.model.RequestDefinition;
import org.mockserver.scheduler.Scheduler;
import org.slf4j.event.Level;

public abstract class AbstractMockingIntegrationTestBase {
    private static final MockServerLogger MOCK_SERVER_LOGGER = new MockServerLogger(AbstractMockingIntegrationTestBase.class);
    protected static MockServerClient mockServerClient;
    protected static String servletContext;
    protected static final List<String> headersToIgnore;
    protected static EchoServer insecureEchoServer;
    protected static EchoServer secureEchoServer;
    private static EventLoopGroup clientEventLoopGroup;
    static NettyHttpClient httpClient;

    @BeforeClass
    public static void startEchoServer() {
        if (insecureEchoServer == null) {
            insecureEchoServer = new EchoServer(false);
        }
        if (secureEchoServer == null) {
            secureEchoServer = new EchoServer(true);
        }
    }

    @BeforeClass
    public static void resetServletContext() {
        servletContext = "";
    }

    public abstract int getServerPort();

    public int getServerSecurePort() {
        return this.getServerPort();
    }

    @Before
    public void resetServer() {
        block2: {
            try {
                mockServerClient.reset();
            }
            catch (Throwable throwable) {
                if (!MockServerLogger.isEnabled((Level)Level.WARN)) break block2;
                MOCK_SERVER_LOGGER.logEvent(new LogEntry().setLogLevel(Level.WARN).setMessageFormat("exception while resetting - " + throwable.getMessage()).setThrowable(throwable));
            }
        }
    }

    protected String calculatePath(String path) {
        return (!path.startsWith("/") ? "/" : "") + path;
    }

    @BeforeClass
    public static void createClientAndEventLoopGroup() {
        clientEventLoopGroup = new NioEventLoopGroup(3, (ThreadFactory)new Scheduler.SchedulerThreadFactory(AbstractMockingIntegrationTestBase.class.getSimpleName() + "-eventLoop"));
        httpClient = new NettyHttpClient(new MockServerLogger(), clientEventLoopGroup, null, false);
    }

    @AfterClass
    public static void stopEventLoopGroup() {
        clientEventLoopGroup.shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS).syncUninterruptibly();
    }

    String addContextToPath(String path) {
        String cleanedPath = path;
        if (StringUtils.isNotBlank((CharSequence)servletContext)) {
            cleanedPath = (!servletContext.startsWith("/") ? "/" : "") + servletContext + (!servletContext.endsWith("/") ? "/" : "") + (cleanedPath.startsWith("/") ? cleanedPath.substring(1) : cleanedPath);
        }
        return (!cleanedPath.startsWith("/") ? "/" : "") + cleanedPath;
    }

    protected void verifyRequestsMatches(RequestDefinition[] requestDefinitions, HttpRequest ... httpRequestMatchers) {
        if (requestDefinitions.length != httpRequestMatchers.length) {
            throw new AssertionError((Object)("Number of request matchers does not match number of requests, expected:<" + httpRequestMatchers.length + "> but was:<" + requestDefinitions.length + ">"));
        }
        for (int i = 0; i < httpRequestMatchers.length; ++i) {
            if (!new MatcherBuilder(MOCK_SERVER_LOGGER).transformsToMatcher((RequestDefinition)httpRequestMatchers[i]).matches(null, requestDefinitions[i])) {
                throw new AssertionError((Object)("Request does not match request matcher, expected <" + httpRequestMatchers[i] + "> but was:<" + requestDefinitions[i] + ">, full list requests is: " + Arrays.toString(httpRequestMatchers)));
            }
        }
    }

    protected HttpResponse makeRequest(HttpRequest httpRequest, Collection<String> headersToIgnore) {
        try {
            boolean isSsl = httpRequest.isSecure() != null && httpRequest.isSecure() != false;
            int port = isSsl ? this.getServerSecurePort() : this.getServerPort();
            httpRequest.withPath(this.addContextToPath(httpRequest.getPath().getValue()));
            if (!httpRequest.containsHeader(HttpHeaderNames.HOST.toString())) {
                httpRequest.withHeader(HttpHeaderNames.HOST.toString(), new String[]{"localhost:" + port});
            }
            boolean isDebug = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().indexOf("-agentlib:jdwp") > 0;
            HttpResponse httpResponse = (HttpResponse)httpClient.sendRequest(httpRequest, new InetSocketAddress("localhost", port)).get(30L, isDebug ? TimeUnit.MINUTES : TimeUnit.SECONDS);
            Headers headers = new Headers(new Header[0]);
            for (Header header : httpResponse.getHeaderList()) {
                if (headersToIgnore.contains(header.getName().getValue().toLowerCase())) continue;
                if (header.getName().getValue().equalsIgnoreCase(HttpHeaderNames.CONTENT_TYPE.toString())) {
                    for (NottableString value : new ArrayList(header.getValues())) {
                        header.getValues().clear();
                        header.addValues(new String[]{value.getValue().replace(";charset", "; charset")});
                    }
                    header = Header.header((NottableString)header.getName().lowercase(), (Collection)header.getValues());
                }
                headers.withEntry((KeyToMultiValue)header);
            }
            httpResponse.withHeaders(headers);
            httpResponse.withReasonPhrase(StringUtils.isBlank((CharSequence)httpResponse.getReasonPhrase()) ? HttpResponseStatus.valueOf((int)httpResponse.getStatusCode()).reasonPhrase() : httpResponse.getReasonPhrase());
            return httpResponse;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        servletContext = "";
        headersToIgnore = ImmutableList.of((Object)HttpHeaderNames.SERVER.toString(), (Object)HttpHeaderNames.EXPIRES.toString(), (Object)HttpHeaderNames.DATE.toString(), (Object)HttpHeaderNames.HOST.toString(), (Object)HttpHeaderNames.CONNECTION.toString(), (Object)HttpHeaderNames.USER_AGENT.toString(), (Object)HttpHeaderNames.CONTENT_LENGTH.toString(), (Object)HttpHeaderNames.ACCEPT_ENCODING.toString(), (Object)HttpHeaderNames.TRANSFER_ENCODING.toString(), (Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN.toString(), (Object)HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS.toString(), (Object)HttpHeaderNames.VARY.toString(), (Object[])new String[]{HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS.toString(), HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS.toString(), HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS.toString(), HttpHeaderNames.ACCESS_CONTROL_MAX_AGE.toString(), HttpHeaderNames.KEEP_ALIVE.toString(), "version", "x-cors"});
    }
}

