/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client;

import com.google.common.annotations.VisibleForTesting;
import org.mockserver.client.ClientException;
import org.mockserver.client.MockServerClient;
import org.mockserver.client.MockServerEventBus;
import org.mockserver.client.netty.websocket.WebSocketClient;
import org.mockserver.client.netty.websocket.WebSocketException;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.mock.action.ExpectationResponseCallback;
import org.mockserver.model.HttpClassCallback;
import org.mockserver.model.HttpError;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpObjectCallback;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpTemplate;

public class ForwardChainExpectation {
    private final MockServerClient mockServerClient;
    private final Expectation expectation;
    private WebSocketClient webSocketClient;

    ForwardChainExpectation(MockServerClient mockServerClient, Expectation expectation) {
        this.mockServerClient = mockServerClient;
        this.expectation = expectation;
        MockServerEventBus.getInstance().subscribe(new MockServerEventBus.SubscriberHandler(){

            @Override
            public void handle() {
                if (ForwardChainExpectation.this.webSocketClient != null) {
                    ForwardChainExpectation.this.webSocketClient.stopClient();
                }
            }
        }, MockServerEventBus.EventType.STOP, MockServerEventBus.EventType.RESET);
    }

    public void respond(HttpResponse httpResponse) {
        this.expectation.thenRespond(httpResponse);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(HttpTemplate httpTemplate) {
        this.expectation.thenRespond(httpTemplate);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(HttpClassCallback httpClassCallback) {
        this.expectation.thenRespond(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void respond(ExpectationResponseCallback expectationResponseCallback) {
        this.initWebSocketClient();
        try {
            this.expectation.thenRespond(new HttpObjectCallback().withClientId(this.webSocketClient.registerExpectationCallback(expectationResponseCallback).clientId()));
        }
        catch (WebSocketException wse) {
            throw new ClientException(wse.getMessage());
        }
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpForward httpForward) {
        this.expectation.thenForward(httpForward);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpTemplate httpTemplate) {
        this.expectation.thenForward(httpTemplate);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpClassCallback httpClassCallback) {
        this.expectation.thenForward(httpClassCallback);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(ExpectationForwardCallback expectationForwardCallback) {
        this.initWebSocketClient();
        try {
            this.expectation.thenForward(new HttpObjectCallback().withClientId(this.webSocketClient.registerExpectationCallback(expectationForwardCallback).clientId()));
        }
        catch (WebSocketException wse) {
            throw new ClientException(wse.getMessage());
        }
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void forward(HttpOverrideForwardedRequest httpOverrideForwardedRequest) {
        this.expectation.thenForward(httpOverrideForwardedRequest);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    public void error(HttpError httpError) {
        this.expectation.thenError(httpError);
        this.mockServerClient.sendExpectation(this.expectation);
    }

    private void initWebSocketClient() {
        if (this.webSocketClient == null) {
            this.webSocketClient = new WebSocketClient(this.mockServerClient.getEventLoopGroup(), this.mockServerClient.remoteAddress(), this.mockServerClient.contextPath(), this.mockServerClient.isSecure());
        }
    }

    @VisibleForTesting
    Expectation getExpectation() {
        return this.expectation;
    }

    @VisibleForTesting
    void setWebSocketClient(WebSocketClient webSocketClient) {
        this.webSocketClient = webSocketClient;
    }
}

