/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.supplementary.CliRestrictionOption;
import org.mobicents.protocols.ss7.map.api.service.supplementary.OverrideCategory;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSSubscriptionOption;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SSSubscriptionOptionImpl
implements SSSubscriptionOption,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "SSSubscriptionOption";
    public static final int _TAG_cliRestrictionOption = 2;
    public static final int _TAG_overrideCategory = 1;
    private CliRestrictionOption cliRestrictionOption = null;
    private OverrideCategory overrideCategory = null;

    public SSSubscriptionOptionImpl() {
    }

    public SSSubscriptionOptionImpl(CliRestrictionOption cliRestrictionOption) {
        this.cliRestrictionOption = cliRestrictionOption;
    }

    public SSSubscriptionOptionImpl(OverrideCategory overrideCategory) {
        this.overrideCategory = overrideCategory;
    }

    public CliRestrictionOption getCliRestrictionOption() {
        return this.cliRestrictionOption;
    }

    public OverrideCategory getOverrideCategory() {
        return this.overrideCategory;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.cliRestrictionOption != null) {
            return 2;
        }
        if (this.overrideCategory != null) {
            return 1;
        }
        throw new MAPException("No of choices are supplied");
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SSSubscriptionOption: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SSSubscriptionOption: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SSSubscriptionOption: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SSSubscriptionOption: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.cliRestrictionOption = null;
        this.overrideCategory = null;
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding SSSubscriptionOption: bad tag class or is not primitive: TagClass=" + ais.getTagClass(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (ais.getTag()) {
            case 2: {
                this.cliRestrictionOption = CliRestrictionOption.getInstance((int)((int)ais.readIntegerData(length)));
                break;
            }
            case 1: {
                this.overrideCategory = OverrideCategory.getInstance((int)((int)ais.readIntegerData(length)));
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while SSSubscriptionOption: bad tag: " + ais.getTag(), MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SSSubscriptionOption: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.cliRestrictionOption == null && this.overrideCategory == null) {
            throw new MAPException("Error while encoding SSSubscriptionOption: missing cliRestrictionOption and overrideCategory.");
        }
        if (this.cliRestrictionOption != null && this.overrideCategory != null) {
            throw new MAPException("Error while encoding SSSubscriptionOption: both cliRestrictionOption and overrideCategory are defined.");
        }
        try {
            if (this.cliRestrictionOption != null) {
                asnOs.writeIntegerData((long)this.cliRestrictionOption.getCode());
            } else {
                asnOs.writeIntegerData((long)this.overrideCategory.getCode());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding SSSubscriptionOption: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SSSubscriptionOption [");
        if (this.cliRestrictionOption != null) {
            sb.append("cliRestrictionOption=");
            sb.append(this.cliRestrictionOption.toString());
            sb.append(", ");
        }
        if (this.overrideCategory != null) {
            sb.append("overrideCategory=");
            sb.append(this.overrideCategory.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

