/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertReason;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMRequest;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsMessageImpl;

public class ReadyForSMRequestImpl
extends SmsMessageImpl
implements ReadyForSMRequest {
    protected static final int _TAG_imsi = 0;
    protected static final int _TAG_additionalAlertReasonIndicator = 1;
    public static final String _PrimitiveName = "ReadyForSMRequest";
    private IMSI imsi;
    private AlertReason alertReason;
    private boolean alertReasonIndicator;
    private MAPExtensionContainer extensionContainer;
    private boolean additionalAlertReasonIndicator;

    public ReadyForSMRequestImpl() {
    }

    public ReadyForSMRequestImpl(IMSI imsi, AlertReason alertReason, boolean alertReasonIndicator, MAPExtensionContainer extensionContainer, boolean additionalAlertReasonIndicator) {
        this.imsi = imsi;
        this.alertReason = alertReason;
        this.alertReasonIndicator = alertReasonIndicator;
        this.extensionContainer = extensionContainer;
        this.additionalAlertReasonIndicator = additionalAlertReasonIndicator;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.readyForSM_Request;
    }

    public int getOperationCode() {
        return 66;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public AlertReason getAlertReason() {
        return this.alertReason;
    }

    public boolean getAlertReasonIndicator() {
        return this.alertReasonIndicator;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getAdditionalAlertReasonIndicator() {
        return this.additionalAlertReasonIndicator;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.alertReason = null;
        this.alertReasonIndicator = false;
        this.extensionContainer = null;
        this.additionalAlertReasonIndicator = false;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 10: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest.alertReason: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.alertReason = AlertReason.getInstance((int)i1);
                        break;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest.alertReasonIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.alertReasonIndicator = true;
                        break;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest.extensionContainer: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest.imsi: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.imsi = new IMSIImpl();
                        ((IMSIImpl)this.imsi).decodeAll(ais);
                        break;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest.additionalAlertReasonIndicator: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.additionalAlertReasonIndicator = true;
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
            } else {
                ais.advanceElement();
            }
            ++num;
        }
        if (this.imsi == null) {
            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest: Parameter imsi is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.alertReason == null) {
            throw new MAPParsingComponentException("Error while decoding ReadyForSMRequest: Parameter alertReason is mandator but not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imsi == null) {
                throw new MAPException("IMSI parameter must not be null");
            }
            if (this.alertReason == null) {
                throw new MAPException("alertReason parameter must not be null");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs, 2, 0);
            asnOs.writeInteger(0, 10, (long)this.alertReason.getCode());
            if (this.alertReasonIndicator) {
                asnOs.writeNull();
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.additionalAlertReasonIndicator) {
                asnOs.writeNull(2, 1);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding ReadyForSMRequest: " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi);
            sb.append(", ");
        }
        if (this.alertReason != null) {
            sb.append("alertReason");
            sb.append(this.alertReason);
            sb.append(", ");
        }
        if (this.alertReasonIndicator) {
            sb.append("alertReasonIndicator, ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer);
            sb.append(", ");
        }
        if (this.additionalAlertReasonIndicator) {
            sb.append("additionalAlertReasonIndicator, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

