/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.AMBR;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APNConfigurationProfile;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APNOIReplacement;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.EPSSubscriptionData;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.AMBRImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNConfigurationProfileImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNOIReplacementImpl;

public class EPSSubscriptionDataImpl
extends SequenceBase
implements EPSSubscriptionData {
    private static final int _TAG_apnOiReplacement = 0;
    private static final int _TAG_rfspId = 2;
    private static final int _TAG_ambr = 3;
    private static final int _TAG_apnConfigurationProfile = 4;
    private static final int _TAG_stnSr = 6;
    private static final int _TAG_extensionContainer = 5;
    private static final int _TAG_mpsCSPriority = 7;
    private static final int _TAG_mpsEPSPriority = 8;
    private APNOIReplacement apnOiReplacement;
    private Integer rfspId;
    private AMBR ambr;
    private APNConfigurationProfile apnConfigurationProfile;
    private ISDNAddressString stnSr;
    private MAPExtensionContainer extensionContainer;
    private boolean mpsCSPriority;
    private boolean mpsEPSPriority;

    public EPSSubscriptionDataImpl() {
        super("EPSSubscriptionData");
    }

    public EPSSubscriptionDataImpl(APNOIReplacement apnOiReplacement, Integer rfspId, AMBR ambr, APNConfigurationProfile apnConfigurationProfile, ISDNAddressString stnSr, MAPExtensionContainer extensionContainer, boolean mpsCSPriority, boolean mpsEPSPriority) {
        super("EPSSubscriptionData");
        this.apnOiReplacement = apnOiReplacement;
        this.rfspId = rfspId;
        this.ambr = ambr;
        this.apnConfigurationProfile = apnConfigurationProfile;
        this.stnSr = stnSr;
        this.extensionContainer = extensionContainer;
        this.mpsCSPriority = mpsCSPriority;
        this.mpsEPSPriority = mpsEPSPriority;
    }

    public APNOIReplacement getApnOiReplacement() {
        return this.apnOiReplacement;
    }

    public Integer getRfspId() {
        return this.rfspId;
    }

    public AMBR getAmbr() {
        return this.ambr;
    }

    public APNConfigurationProfile getAPNConfigurationProfile() {
        return this.apnConfigurationProfile;
    }

    public ISDNAddressString getStnSr() {
        return this.stnSr;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getMpsCSPriority() {
        return this.mpsCSPriority;
    }

    public boolean getMpsEPSPriority() {
        return this.mpsEPSPriority;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.apnOiReplacement = null;
        this.rfspId = null;
        this.ambr = null;
        this.apnConfigurationProfile = null;
        this.stnSr = null;
        this.extensionContainer = null;
        this.mpsCSPriority = false;
        this.mpsEPSPriority = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block13: while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".apnOiReplacement: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.apnOiReplacement = new APNOIReplacementImpl();
                            ((APNOIReplacementImpl)this.apnOiReplacement).decodeAll(ais);
                            continue block13;
                        }
                        case 2: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".rfspId: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.rfspId = new Integer((int)ais.readInteger());
                            continue block13;
                        }
                        case 3: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ambr: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.ambr = new AMBRImpl();
                            ((AMBRImpl)this.ambr).decodeAll(ais);
                            continue block13;
                        }
                        case 4: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".apnConfigurationProfile: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.apnConfigurationProfile = new APNConfigurationProfileImpl();
                            ((APNConfigurationProfileImpl)this.apnConfigurationProfile).decodeAll(ais);
                            continue block13;
                        }
                        case 6: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".stnSr: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.stnSr = new ISDNAddressStringImpl();
                            ((ISDNAddressStringImpl)this.stnSr).decodeAll(ais);
                            continue block13;
                        }
                        case 5: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            continue block13;
                        }
                        case 7: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".mpsCSPriority: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.mpsCSPriority = true;
                            continue block13;
                        }
                        case 8: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".mpsEPSPriority: Parameter not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            ais.readNull();
                            this.mpsEPSPriority = true;
                            continue block13;
                        }
                    }
                    ais.advanceElement();
                    continue block13;
                }
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.apnOiReplacement != null) {
                ((APNOIReplacementImpl)this.apnOiReplacement).encodeAll(asnOs, 2, 0);
            }
            if (this.rfspId != null) {
                asnOs.writeInteger(2, 2, (long)this.rfspId.intValue());
            }
            if (this.ambr != null) {
                ((AMBRImpl)this.ambr).encodeAll(asnOs, 2, 3);
            }
            if (this.apnConfigurationProfile != null) {
                ((APNConfigurationProfileImpl)this.apnConfigurationProfile).encodeAll(asnOs, 2, 4);
            }
            if (this.stnSr != null) {
                ((ISDNAddressStringImpl)this.stnSr).encodeAll(asnOs, 2, 6);
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 5);
            }
            if (this.mpsCSPriority) {
                asnOs.writeNull(2, 7);
            }
            if (this.mpsEPSPriority) {
                asnOs.writeNull(2, 8);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        if (this.apnOiReplacement != null) {
            sb.append("apnOiReplacement=");
            sb.append(this.apnOiReplacement.toString());
            sb.append(", ");
        }
        if (this.rfspId != null) {
            sb.append("rfspId=");
            sb.append(this.rfspId.toString());
            sb.append(", ");
        }
        if (this.ambr != null) {
            sb.append("ambr=");
            sb.append(this.ambr.toString());
            sb.append(", ");
        }
        if (this.apnConfigurationProfile != null) {
            sb.append("apnConfigurationProfile=");
            sb.append(this.apnConfigurationProfile.toString());
            sb.append(", ");
        }
        if (this.stnSr != null) {
            sb.append("stnSr=");
            sb.append(this.stnSr.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.mpsCSPriority) {
            sb.append("mpsCSPriority, ");
        }
        if (this.mpsEPSPriority) {
            sb.append("mpsEPSPriority ");
        }
        sb.append("]");
        return sb.toString();
    }
}

