/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement;

import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.ChargingCharacteristics;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;

public class ChargingCharacteristicsImpl
extends OctetStringBase
implements ChargingCharacteristics {
    public static final int _FLAG_NORMAL_CHARGING = 8;
    public static final int _FLAG_PREPAID_CHARGING = 4;
    public static final int _FLAG_FLAT_RATE_CHARGING_CHARGING = 2;
    public static final int _FLAG_CHARGING_BY_HOT_BILLING_CHARGING = 1;

    public ChargingCharacteristicsImpl() {
        super(2, 2, "ChargingCharacteristics");
    }

    public ChargingCharacteristicsImpl(byte[] data) {
        super(2, 2, "ChargingCharacteristics", data);
    }

    public ChargingCharacteristicsImpl(boolean isNormalCharging, boolean isPrepaidCharging, boolean isFlatRateChargingCharging, boolean isChargingByHotBillingCharging) {
        super(2, 2, "ChargingCharacteristics");
        this.data = new byte[2];
        if (isNormalCharging) {
            this.data[0] = (byte)(this.data[0] | 8);
        }
        if (isPrepaidCharging) {
            this.data[0] = (byte)(this.data[0] | 4);
        }
        if (isFlatRateChargingCharging) {
            this.data[0] = (byte)(this.data[0] | 2);
        }
        if (isChargingByHotBillingCharging) {
            this.data[0] = (byte)(this.data[0] | 1);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    private boolean isDataGoodFormed() {
        return this.data != null && this.data.length == 2;
    }

    public boolean isNormalCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 8) != 0;
    }

    public boolean isPrepaidCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 4) != 0;
    }

    public boolean isFlatRateChargingCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 2) != 0;
    }

    public boolean isChargingByHotBillingCharging() {
        return this.isDataGoodFormed() && (this.data[0] & 1) != 0;
    }

    @Override
    public String toString() {
        if (this.isDataGoodFormed()) {
            boolean normalCharging = this.isNormalCharging();
            boolean prepaidCharging = this.isPrepaidCharging();
            boolean flatRateChargingCharging = this.isFlatRateChargingCharging();
            boolean chargingByHotBillingCharging = this.isChargingByHotBillingCharging();
            StringBuilder sb = new StringBuilder();
            sb.append(this._PrimitiveName);
            sb.append(" [Data= ");
            sb.append(this.printDataArr());
            if (normalCharging) {
                sb.append(", normalCharging");
            }
            if (prepaidCharging) {
                sb.append(", prepaidCharging");
            }
            if (flatRateChargingCharging) {
                sb.append(", flatRateChargingCharging");
            }
            if (chargingByHotBillingCharging) {
                sb.append(", chargingByHotBillingCharging");
            }
            sb.append("]");
            return sb.toString();
        }
        return super.toString();
    }
}

