/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.asn.BitSetStrictLength;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SupportedRATTypes;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;

public class SupportedRATTypesImpl
implements SupportedRATTypes,
MAPAsnPrimitive {
    private static final int _INDEX_utran = 0;
    private static final int _INDEX_geran = 1;
    private static final int _INDEX_gan = 2;
    private static final int _INDEX_i_hspa_evolution = 3;
    private static final int _INDEX_e_utran = 4;
    public static final String _PrimitiveName = "SupportedRATTypes";
    private BitSetStrictLength bitString = new BitSetStrictLength(5);

    public SupportedRATTypesImpl() {
    }

    public SupportedRATTypesImpl(boolean utran, boolean geran, boolean gan, boolean i_hspa_evolution, boolean e_utran) {
        if (utran) {
            this.bitString.set(0);
        }
        if (geran) {
            this.bitString.set(1);
        }
        if (gan) {
            this.bitString.set(2);
        }
        if (i_hspa_evolution) {
            this.bitString.set(3);
        }
        if (e_utran) {
            this.bitString.set(4);
        }
    }

    @Override
    public int getTag() throws MAPException {
        return 3;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    public boolean getUtran() {
        return this.bitString.get(0);
    }

    public boolean getGeran() {
        return this.bitString.get(1);
    }

    public boolean getGan() {
        return this.bitString.get(2);
    }

    public boolean getIHspaEvolution() {
        return this.bitString.get(3);
    }

    public boolean getEUtran() {
        return this.bitString.get(4);
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SupportedRATTypes: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SupportedRATTypes: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding SupportedRATTypes: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding SupportedRATTypes: " + e.getMessage(), (Throwable)e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        if (length < 1 || length > 2) {
            throw new MAPParsingComponentException("Error decoding SupportedRATTypes: the field must contain from 1 or 2 octets. Contains: " + length, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        this.bitString = ansIS.readBitStringData(length);
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SupportedRATTypes: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            asnOs.writeBitStringData(this.bitString);
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding SupportedRATTypes: " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding SupportedRATTypes: " + e.getMessage(), (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bitString == null ? 0 : this.bitString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SupportedRATTypesImpl other = (SupportedRATTypesImpl)obj;
        return !(this.bitString == null ? other.bitString != null : !this.bitString.equals((Object)other.bitString));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SupportedRATTypes [");
        if (this.getUtran()) {
            sb.append("utran, ");
        }
        if (this.getGeran()) {
            sb.append("geran, ");
        }
        if (this.getGan()) {
            sb.append("gan, ");
        }
        if (this.getIHspaEvolution()) {
            sb.append("i_hspa_evolution, ");
        }
        if (this.getEUtran()) {
            sb.append("e_utran, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

