/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PDNGWUpdate;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.APN;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.PDNGWIdentity;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.APNImpl;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.PDNGWIdentityImpl;

public class PDNGWUpdateImpl
extends SequenceBase
implements PDNGWUpdate {
    public static final int _TAG_apn = 0;
    public static final int _TAG_pdnGwIdentity = 1;
    public static final int _TAG_contextId = 2;
    public static final int _TAG_extensionContainer = 3;
    private APN apn;
    private PDNGWIdentity pdnGwIdentity;
    private Integer contextId;
    private MAPExtensionContainer extensionContainer;

    public PDNGWUpdateImpl() {
        super("PDNGWUpdate");
    }

    public PDNGWUpdateImpl(APN apn, PDNGWIdentity pdnGwIdentity, Integer contextId, MAPExtensionContainer extensionContainer) {
        super("PDNGWUpdate");
        this.apn = apn;
        this.pdnGwIdentity = pdnGwIdentity;
        this.contextId = contextId;
        this.extensionContainer = extensionContainer;
    }

    public APN getAPN() {
        return this.apn;
    }

    public PDNGWIdentity getPdnGwIdentity() {
        return this.pdnGwIdentity;
    }

    public Integer getContextId() {
        return this.contextId;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.apn = null;
        this.pdnGwIdentity = null;
        this.contextId = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (ais.getTagClass()) {
                case 2: {
                    switch (tag) {
                        case 0: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".apn: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.apn = new APNImpl();
                            ((APNImpl)this.apn).decodeAll(ais);
                            break block0;
                        }
                        case 1: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".pdnGwIdentity: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.pdnGwIdentity = new PDNGWIdentityImpl();
                            ((PDNGWIdentityImpl)this.pdnGwIdentity).decodeAll(ais);
                            break block0;
                        }
                        case 2: {
                            if (!ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".contextId: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int cntxId = (int)ais.readInteger();
                            this.contextId = new Integer(cntxId);
                            break block0;
                        }
                        case 3: {
                            if (ais.isTagPrimitive()) {
                                throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.extensionContainer = new MAPExtensionContainerImpl();
                            ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                            break block0;
                        }
                    }
                    ais.advanceElement();
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.apn != null) {
                ((APNImpl)this.apn).encodeAll(asnOs, 2, 0);
            }
            if (this.pdnGwIdentity != null) {
                ((PDNGWIdentityImpl)this.pdnGwIdentity).encodeAll(asnOs, 2, 1);
            }
            if (this.contextId != null) {
                asnOs.writeInteger(2, 2, (long)this.contextId.intValue());
            }
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.apn != null) {
            sb.append("apn=");
            sb.append(this.apn.toString());
            sb.append(", ");
        }
        if (this.pdnGwIdentity != null) {
            sb.append("pdnGwIdentity=");
            sb.append(this.pdnGwIdentity.toString());
            sb.append(", ");
        }
        if (this.contextId != null) {
            sb.append("contextId=");
            sb.append(this.contextId.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

