/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.LMSI;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.IMSIWithLMSI;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.LMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;

public class IMSIWithLMSIImpl
extends SequenceBase
implements IMSIWithLMSI {
    private IMSI imsi;
    private LMSI lmsi;

    public IMSIWithLMSIImpl() {
        super("IMSIWithLMSI");
    }

    public IMSIWithLMSIImpl(IMSI imsi, LMSI lmsi) {
        super("IMSIWithLMSI");
        this.imsi = imsi;
        this.lmsi = lmsi;
    }

    @Override
    protected void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.lmsi = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            switch (num) {
                case 0: {
                    if (tag != 4 && ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter imsi has bad tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imsi = new IMSIImpl();
                    ((IMSIImpl)this.imsi).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (tag != 4 && ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter lmsi has bad tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.lmsi = new LMSIImpl();
                    ((LMSIImpl)this.lmsi).decodeAll(ais);
                    break;
                }
                default: {
                    ais.advanceElement();
                }
            }
            ++num;
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.imsi == null || this.lmsi == null) {
            throw new MAPException("Error while decoding " + this._PrimitiveName + " : lmsi or lmsi is null");
        }
        ((IMSIImpl)this.imsi).encodeAll(asnOs);
        ((LMSIImpl)this.lmsi).encodeAll(asnOs);
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public LMSI getLmsi() {
        return this.lmsi;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.lmsi != null) {
            sb.append("lmsi=");
            sb.append(this.lmsi.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

